/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationUtils {
    public static void copyPropertiesToBean(Annotation ann, Object bean, String ... excludedProperties) {
        HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludedProperties));
        Method[] annotationProperties = ann.annotationType().getDeclaredMethods();
        BeanWrapperImpl bw = new BeanWrapperImpl(bean);
        for (Method annotationProperty : annotationProperties) {
            String propertyName = annotationProperty.getName();
            if (excluded.contains(propertyName) || !bw.isWritableProperty(propertyName)) continue;
            Object value = ReflectionUtils.invokeMethod(annotationProperty, ann);
            bw.setPropertyValue(propertyName, value);
        }
    }

    public static <A extends Annotation> A findMethodAnnotation(Class<A> annotationClass, Method m, Class c) {
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException(annotationClass + " is not an annotation");
        }
        A annotation = m.getAnnotation(annotationClass);
        while (annotation == null && (c = c.getSuperclass()) != null && !c.equals(Object.class)) {
            try {
                m = c.getDeclaredMethod(m.getName(), m.getParameterTypes());
                annotation = m.getAnnotation(annotationClass);
            }
            catch (NoSuchMethodException ex) {}
        }
        return annotation;
    }
}

