/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlBeanDefinitionParser
implements XmlBeanDefinitionParser {
    public static final String BEANS_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String TRUE_VALUE = "true";
    public static final String DEFAULT_VALUE = "default";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String AUTOWIRE_BY_NAME_VALUE = "byName";
    public static final String AUTOWIRE_BY_TYPE_VALUE = "byType";
    public static final String AUTOWIRE_CONSTRUCTOR_VALUE = "constructor";
    public static final String AUTOWIRE_AUTODETECT_VALUE = "autodetect";
    public static final String DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE = "all";
    public static final String DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE = "simple";
    public static final String DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE = "objects";
    public static final String DEFAULT_LAZY_INIT_ATTRIBUTE = "default-lazy-init";
    public static final String DEFAULT_AUTOWIRE_ATTRIBUTE = "default-autowire";
    public static final String DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE = "default-dependency-check";
    public static final String DEFAULT_INIT_METHOD_ATTRIBUTE = "default-init-method";
    public static final String DEFAULT_DESTROY_METHOD_ATTRIBUTE = "default-destroy-method";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    public static final String ALIAS_ELEMENT = "alias";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ATTRIBUTE = "alias";
    public static final String BEAN_ELEMENT = "bean";
    public static final String ID_ATTRIBUTE = "id";
    public static final String PARENT_ATTRIBUTE = "parent";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ABSTRACT_ATTRIBUTE = "abstract";
    public static final String SINGLETON_ATTRIBUTE = "singleton";
    public static final String LAZY_INIT_ATTRIBUTE = "lazy-init";
    public static final String AUTOWIRE_ATTRIBUTE = "autowire";
    public static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String INIT_METHOD_ATTRIBUTE = "init-method";
    public static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    public static final String FACTORY_METHOD_ATTRIBUTE = "factory-method";
    public static final String FACTORY_BEAN_ATTRIBUTE = "factory-bean";
    public static final String CONSTRUCTOR_ARG_ELEMENT = "constructor-arg";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String LOOKUP_METHOD_ELEMENT = "lookup-method";
    public static final String REPLACED_METHOD_ELEMENT = "replaced-method";
    public static final String REPLACER_ATTRIBUTE = "replacer";
    public static final String ARG_TYPE_ELEMENT = "arg-type";
    public static final String ARG_TYPE_MATCH_ATTRIBUTE = "match";
    public static final String REF_ELEMENT = "ref";
    public static final String IDREF_ELEMENT = "idref";
    public static final String BEAN_REF_ATTRIBUTE = "bean";
    public static final String LOCAL_REF_ATTRIBUTE = "local";
    public static final String PARENT_REF_ATTRIBUTE = "parent";
    public static final String VALUE_ELEMENT = "value";
    public static final String NULL_ELEMENT = "null";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ELEMENT = "key";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String KEY_REF_ATTRIBUTE = "key-ref";
    public static final String VALUE_REF_ATTRIBUTE = "value-ref";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanDefinitionReader beanDefinitionReader;
    private NamespaceHandlerResolver namespaceHandlerResolver;
    private Resource resource;
    private String defaultLazyInit;
    private String defaultAutowire;
    private String defaultDependencyCheck;
    private String defaultInitMethod;
    private String defaultDestroyMethod;

    public int registerBeanDefinitions(BeanDefinitionReader reader, Document doc, Resource resource) throws BeanDefinitionStoreException {
        this.beanDefinitionReader = reader;
        this.resource = resource;
        this.logger.debug((Object)"Loading bean definitions");
        Element root = doc.getDocumentElement();
        this.initDefaults(root);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Default lazy init '" + this.getDefaultLazyInit() + "'"));
            this.logger.debug((Object)("Default autowire '" + this.getDefaultAutowire() + "'"));
            this.logger.debug((Object)("Default dependency check '" + this.getDefaultDependencyCheck() + "'"));
        }
        this.preProcessXml(root);
        int beanDefinitionCount = this.parseBeanDefinitions(root);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found " + beanDefinitionCount + " <bean> elements in " + resource));
        }
        this.postProcessXml(root);
        return beanDefinitionCount;
    }

    protected final BeanDefinitionReader getBeanDefinitionReader() {
        return this.beanDefinitionReader;
    }

    protected final Resource getResource() {
        return this.resource;
    }

    protected void initDefaults(Element root) {
        this.setDefaultLazyInit(root.getAttribute(DEFAULT_LAZY_INIT_ATTRIBUTE));
        this.setDefaultAutowire(root.getAttribute(DEFAULT_AUTOWIRE_ATTRIBUTE));
        this.setDefaultDependencyCheck(root.getAttribute(DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE));
        if (root.hasAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE)) {
            this.setDefaultInitMethod(root.getAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE));
        }
        if (root.hasAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE)) {
            this.setDefaultDestroyMethod(root.getAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE));
        }
    }

    protected final void setDefaultLazyInit(String defaultLazyInit) {
        this.defaultLazyInit = defaultLazyInit;
    }

    protected final String getDefaultLazyInit() {
        return this.defaultLazyInit;
    }

    protected final void setDefaultAutowire(String defaultAutowire) {
        this.defaultAutowire = defaultAutowire;
    }

    protected final String getDefaultAutowire() {
        return this.defaultAutowire;
    }

    protected final void setDefaultDependencyCheck(String defaultDependencyCheck) {
        this.defaultDependencyCheck = defaultDependencyCheck;
    }

    protected final String getDefaultDependencyCheck() {
        return this.defaultDependencyCheck;
    }

    protected final void setDefaultInitMethod(String defaultInitMethod) {
        this.defaultInitMethod = defaultInitMethod;
    }

    protected final String getDefaultInitMethod() {
        return this.defaultInitMethod;
    }

    protected final void setDefaultDestroyMethod(String defaultDestroyMethod) {
        this.defaultDestroyMethod = defaultDestroyMethod;
    }

    protected final String getDefaultDestroyMethod() {
        return this.defaultDestroyMethod;
    }

    protected void preProcessXml(Element root) throws BeanDefinitionStoreException {
    }

    protected NamespaceHandlerResolver createNamespaceHandlerResolver() {
        ClassLoader classLoader = this.beanDefinitionReader.getBeanClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return new DefaultNamespaceHandlerResolver(classLoader);
    }

    protected int parseBeanDefinitions(Element root) throws BeanDefinitionStoreException {
        NodeList nl = root.getChildNodes();
        int beanDefinitionCount = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String namespaceUri = ele.getNamespaceURI();
            if (this.isDefaultNamespace(namespaceUri)) {
                beanDefinitionCount += this.parseDefaultElement(ele);
                continue;
            }
            beanDefinitionCount += this.parseCustomElement(ele);
        }
        return beanDefinitionCount;
    }

    private boolean isDefaultNamespace(String namespaceUri) {
        return namespaceUri == null || BEANS_NAMESPACE_URI.equals(namespaceUri);
    }

    private int parseDefaultElement(Element ele) {
        if (IMPORT_ELEMENT.equals(ele.getNodeName())) {
            this.importBeanDefinitionResource(ele);
            return 0;
        }
        if ("alias".equals(ele.getNodeName())) {
            String name = ele.getAttribute(NAME_ATTRIBUTE);
            String alias = ele.getAttribute("alias");
            this.beanDefinitionReader.getBeanFactory().registerAlias(name, alias);
            return 0;
        }
        if ("bean".equals(ele.getNodeName())) {
            BeanDefinitionHolder bdHolder = this.parseBeanDefinitionElement(ele, false);
            return this.decorateAndRegisterBeanDefinition(ele, bdHolder);
        }
        return 0;
    }

    protected int parseCustomElement(Element ele) {
        String namespaceUri = ele.getNamespaceURI();
        NamespaceHandler handler = this.getNamespaceHandlerResolver().resolve(namespaceUri);
        if (handler == null) {
            throw new BeanDefinitionStoreException("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "].");
        }
        int countBefore = this.getBeanDefinitionCount();
        BeanDefinitionParser parser = handler.findParserForElement(ele);
        parser.parse(ele, this.beanDefinitionReader.getBeanFactory());
        return this.getBeanDefinitionCount() - countBefore;
    }

    private NamespaceHandlerResolver getNamespaceHandlerResolver() {
        if (this.namespaceHandlerResolver == null) {
            this.namespaceHandlerResolver = this.createNamespaceHandlerResolver();
        }
        return this.namespaceHandlerResolver;
    }

    private int decorateAndRegisterBeanDefinition(Element element, BeanDefinitionHolder definitionHolder) {
        int registeredCount = 1;
        BeanDefinitionHolder rootDefinition = definitionHolder;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String uri = node.getNamespaceURI();
            if (node.getNodeType() != 1 || this.isDefaultNamespace(uri)) continue;
            Element childElement = (Element)node;
            NamespaceHandler handler = this.getNamespaceHandlerResolver().resolve(uri);
            BeanDefinitionDecorator decorator = handler.findDecoratorForElement(childElement);
            int countBefore = this.getBeanDefinitionCount();
            rootDefinition = decorator.decorate(childElement, rootDefinition, this.beanDefinitionReader.getBeanFactory());
            registeredCount += this.getBeanDefinitionCount() - countBefore;
        }
        BeanDefinitionReaderUtils.registerBeanDefinition(rootDefinition, this.beanDefinitionReader.getBeanFactory());
        return registeredCount;
    }

    private int getBeanDefinitionCount() {
        return this.beanDefinitionReader.getBeanFactory().getBeanDefinitionCount();
    }

    protected void importBeanDefinitionResource(Element ele) throws BeanDefinitionStoreException {
        String location = ele.getAttribute(RESOURCE_ATTRIBUTE);
        if (ResourcePatternUtils.isUrl(location = SystemPropertyUtils.resolvePlaceholders(location))) {
            int importCount = this.getBeanDefinitionReader().loadBeanDefinitions(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
            }
        } else {
            try {
                Resource relativeResource = this.getResource().createRelative(location);
                int importCount = this.getBeanDefinitionReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Invalid relative resource location [" + location + "] to import bean definitions from", ex);
            }
        }
    }

    protected void postProcessXml(Element root) throws BeanDefinitionStoreException {
    }

    protected BeanDefinitionHolder parseBeanDefinitionElement(Element ele, boolean isInnerBean) throws BeanDefinitionStoreException {
        String beanName;
        String id = ele.getAttribute(ID_ATTRIBUTE);
        String nameAttr = ele.getAttribute(NAME_ATTRIBUTE);
        ArrayList<String> aliases = new ArrayList<String>();
        if (StringUtils.hasLength(nameAttr)) {
            String[] nameArr = StringUtils.tokenizeToStringArray(nameAttr, BEAN_NAME_DELIMITERS);
            aliases.addAll(Arrays.asList(nameArr));
        }
        if (!StringUtils.hasText(beanName = id) && !aliases.isEmpty()) {
            beanName = (String)aliases.remove(0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No XML 'id' specified - using '" + beanName + "' as bean name and " + aliases + " as aliases"));
            }
        }
        BeanDefinition beanDefinition = this.parseBeanDefinitionElement(ele, beanName);
        if (!StringUtils.hasText(beanName) && beanDefinition instanceof AbstractBeanDefinition) {
            beanName = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)beanDefinition, this.beanDefinitionReader.getBeanFactory(), isInnerBean);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Neither XML 'id' nor 'name' specified - using generated bean name [" + beanName + "]"));
            }
        }
        String[] aliasesArray = aliases.toArray(new String[aliases.size()]);
        return new BeanDefinitionHolder(beanDefinition, beanName, aliasesArray);
    }

    protected BeanDefinition parseBeanDefinitionElement(Element ele, String beanName) throws BeanDefinitionStoreException {
        String className = null;
        if (ele.hasAttribute(CLASS_ATTRIBUTE)) {
            className = ele.getAttribute(CLASS_ATTRIBUTE);
        }
        String parent = null;
        if (ele.hasAttribute("parent")) {
            parent = ele.getAttribute("parent");
        }
        try {
            String lazyInit;
            String dependencyCheck;
            ConstructorArgumentValues cargs = this.parseConstructorArgElements(ele, beanName);
            MutablePropertyValues pvs = this.parsePropertyElements(ele, beanName);
            AbstractBeanDefinition bd = BeanDefinitionReaderUtils.createBeanDefinition(className, parent, cargs, pvs, this.getBeanDefinitionReader().getBeanClassLoader());
            if (ele.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
                String dependsOn = ele.getAttribute(DEPENDS_ON_ATTRIBUTE);
                bd.setDependsOn(StringUtils.tokenizeToStringArray(dependsOn, BEAN_NAME_DELIMITERS));
            }
            if (ele.hasAttribute(FACTORY_METHOD_ATTRIBUTE)) {
                bd.setFactoryMethodName(ele.getAttribute(FACTORY_METHOD_ATTRIBUTE));
            }
            if (ele.hasAttribute(FACTORY_BEAN_ATTRIBUTE)) {
                bd.setFactoryBeanName(ele.getAttribute(FACTORY_BEAN_ATTRIBUTE));
            }
            if (DEFAULT_VALUE.equals(dependencyCheck = ele.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE))) {
                dependencyCheck = this.getDefaultDependencyCheck();
            }
            bd.setDependencyCheck(this.getDependencyCheck(dependencyCheck));
            String autowire = ele.getAttribute(AUTOWIRE_ATTRIBUTE);
            if (DEFAULT_VALUE.equals(autowire)) {
                autowire = this.getDefaultAutowire();
            }
            bd.setAutowireMode(this.getAutowireMode(autowire));
            if (ele.hasAttribute(INIT_METHOD_ATTRIBUTE)) {
                String initMethodName = ele.getAttribute(INIT_METHOD_ATTRIBUTE);
                if (!"".equals(initMethodName)) {
                    bd.setInitMethodName(initMethodName);
                }
            } else if (this.getDefaultInitMethod() != null) {
                bd.setInitMethodName(this.getDefaultInitMethod());
                bd.setEnforceInitMethod(false);
            }
            if (ele.hasAttribute(DESTROY_METHOD_ATTRIBUTE)) {
                String destroyMethodName = ele.getAttribute(DESTROY_METHOD_ATTRIBUTE);
                if (!"".equals(destroyMethodName)) {
                    bd.setDestroyMethodName(destroyMethodName);
                }
            } else if (this.getDefaultDestroyMethod() != null) {
                bd.setDestroyMethodName(this.getDefaultDestroyMethod());
                bd.setEnforceDestroyMethod(false);
            }
            this.parseLookupOverrideSubElements(ele, beanName, bd.getMethodOverrides());
            this.parseReplacedMethodSubElements(ele, beanName, bd.getMethodOverrides());
            bd.setResourceDescription(this.getResource().getDescription());
            if (ele.hasAttribute(ABSTRACT_ATTRIBUTE)) {
                bd.setAbstract(TRUE_VALUE.equals(ele.getAttribute(ABSTRACT_ATTRIBUTE)));
            }
            if (ele.hasAttribute(SINGLETON_ATTRIBUTE)) {
                bd.setSingleton(TRUE_VALUE.equals(ele.getAttribute(SINGLETON_ATTRIBUTE)));
            }
            if (DEFAULT_VALUE.equals(lazyInit = ele.getAttribute(LAZY_INIT_ATTRIBUTE)) && bd.isSingleton()) {
                lazyInit = this.getDefaultLazyInit();
            }
            bd.setLazyInit(TRUE_VALUE.equals(lazyInit));
            return bd;
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException(this.getResource(), beanName, "Bean class [" + className + "] not found", (Throwable)ex);
        }
        catch (NoClassDefFoundError err) {
            throw new BeanDefinitionStoreException(this.getResource(), beanName, "Class that bean class [" + className + "] depends on not found", (Throwable)err);
        }
    }

    protected int getDependencyCheck(String att) {
        int dependencyCheckCode = 0;
        if (DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 3;
        } else if (DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 2;
        } else if (DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 1;
        }
        return dependencyCheckCode;
    }

    protected int getAutowireMode(String att) {
        int autowire = 0;
        if (AUTOWIRE_BY_NAME_VALUE.equals(att)) {
            autowire = 1;
        } else if (AUTOWIRE_BY_TYPE_VALUE.equals(att)) {
            autowire = 2;
        } else if (AUTOWIRE_CONSTRUCTOR_VALUE.equals(att)) {
            autowire = 3;
        } else if (AUTOWIRE_AUTODETECT_VALUE.equals(att)) {
            autowire = 4;
        }
        return autowire;
    }

    protected ConstructorArgumentValues parseConstructorArgElements(Element beanEle, String beanName) throws BeanDefinitionStoreException {
        NodeList nl = beanEle.getChildNodes();
        ConstructorArgumentValues cargs = new ConstructorArgumentValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !CONSTRUCTOR_ARG_ELEMENT.equals(node.getNodeName())) continue;
            this.parseConstructorArgElement((Element)node, beanName, cargs);
        }
        return cargs;
    }

    protected MutablePropertyValues parsePropertyElements(Element beanEle, String beanName) throws BeanDefinitionStoreException {
        NodeList nl = beanEle.getChildNodes();
        MutablePropertyValues pvs = new MutablePropertyValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !PROPERTY_ELEMENT.equals(node.getNodeName())) continue;
            this.parsePropertyElement((Element)node, beanName, pvs);
        }
        return pvs;
    }

    protected void parseLookupOverrideSubElements(Element beanEle, String beanName, MethodOverrides overrides) throws BeanDefinitionStoreException {
        NodeList nl = beanEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !LOOKUP_METHOD_ELEMENT.equals(node.getNodeName())) continue;
            Element ele = (Element)node;
            String methodName = ele.getAttribute(NAME_ATTRIBUTE);
            String beanRef = ele.getAttribute("bean");
            overrides.addOverride(new LookupOverride(methodName, beanRef));
        }
    }

    protected void parseReplacedMethodSubElements(Element beanEle, String beanName, MethodOverrides overrides) throws BeanDefinitionStoreException {
        NodeList nl = beanEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !REPLACED_METHOD_ELEMENT.equals(node.getNodeName())) continue;
            Element replacedMethodEle = (Element)node;
            String name = replacedMethodEle.getAttribute(NAME_ATTRIBUTE);
            String callback = replacedMethodEle.getAttribute(REPLACER_ATTRIBUTE);
            ReplaceOverride replaceOverride = new ReplaceOverride(name, callback);
            List argTypeEles = DomUtils.getChildElementsByTagName(replacedMethodEle, ARG_TYPE_ELEMENT);
            Iterator it = argTypeEles.iterator();
            while (it.hasNext()) {
                Element argTypeEle = (Element)it.next();
                replaceOverride.addTypeIdentifier(argTypeEle.getAttribute(ARG_TYPE_MATCH_ATTRIBUTE));
            }
            overrides.addOverride(replaceOverride);
        }
    }

    protected void parseConstructorArgElement(Element ele, String beanName, ConstructorArgumentValues cargs) throws BeanDefinitionStoreException {
        Object val = this.parsePropertyValue(ele, beanName, null);
        String indexAttr = ele.getAttribute(INDEX_ATTRIBUTE);
        String typeAttr = ele.getAttribute(TYPE_ATTRIBUTE);
        if (StringUtils.hasLength(indexAttr)) {
            try {
                int index = Integer.parseInt(indexAttr);
                if (index < 0) {
                    throw new BeanDefinitionStoreException(this.getResource(), beanName, "'index' cannot be lower than 0");
                }
                if (StringUtils.hasLength(typeAttr)) {
                    cargs.addIndexedArgumentValue(index, val, typeAttr);
                }
                cargs.addIndexedArgumentValue(index, val);
            }
            catch (NumberFormatException ex) {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, "Attribute 'index' of tag 'constructor-arg' must be an integer");
            }
        } else if (StringUtils.hasLength(typeAttr)) {
            cargs.addGenericArgumentValue(val, typeAttr);
        } else {
            cargs.addGenericArgumentValue(val);
        }
    }

    protected void parsePropertyElement(Element ele, String beanName, MutablePropertyValues pvs) throws BeanDefinitionStoreException {
        String propertyName = ele.getAttribute(NAME_ATTRIBUTE);
        if (!StringUtils.hasLength(propertyName)) {
            throw new BeanDefinitionStoreException(this.getResource(), beanName, "Tag 'property' must have a 'name' attribute");
        }
        if (pvs.contains(propertyName)) {
            throw new BeanDefinitionStoreException(this.getResource(), beanName, "Multiple 'property' definitions for property '" + propertyName + "'");
        }
        Object val = this.parsePropertyValue(ele, beanName, propertyName);
        pvs.addPropertyValue(propertyName, val);
    }

    protected Object parsePropertyValue(Element ele, String beanName, String propertyName) throws BeanDefinitionStoreException {
        String elementName = propertyName != null ? "<property> element for property '" + propertyName + "'" : "<constructor-arg> element";
        NodeList nl = ele.getChildNodes();
        Element subElement = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element candidateEle;
            if (!(nl.item(i) instanceof Element) || DESCRIPTION_ELEMENT.equals((candidateEle = (Element)nl.item(i)).getTagName())) continue;
            if (subElement != null) {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, elementName + " must not contain more than one sub-element");
            }
            subElement = candidateEle;
        }
        boolean hasRefAttribute = ele.hasAttribute("ref");
        boolean hasValueAttribute = ele.hasAttribute("value");
        if (hasRefAttribute && hasValueAttribute || (hasRefAttribute || hasValueAttribute) && subElement != null) {
            throw new BeanDefinitionStoreException(this.getResource(), beanName, elementName + " is only allowed to contain either a 'ref' attribute OR a 'value' attribute OR a sub-element");
        }
        if (hasRefAttribute) {
            return new RuntimeBeanReference(ele.getAttribute("ref"));
        }
        if (hasValueAttribute) {
            return ele.getAttribute("value");
        }
        if (subElement == null) {
            throw new BeanDefinitionStoreException(this.getResource(), beanName, elementName + " must specify a ref or value");
        }
        return this.parsePropertySubElement(subElement, beanName);
    }

    protected Object parsePropertySubElement(Element ele, String beanName) throws BeanDefinitionStoreException {
        if (ele.getTagName().equals("bean")) {
            return this.parseBeanDefinitionElement(ele, true);
        }
        if (ele.getTagName().equals("ref")) {
            String beanRef = ele.getAttribute("bean");
            if (!StringUtils.hasLength(beanRef) && !StringUtils.hasLength(beanRef = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                beanRef = ele.getAttribute("parent");
                if (!StringUtils.hasLength(beanRef)) {
                    throw new BeanDefinitionStoreException(this.getResource(), beanName, "'bean', 'local' or 'parent' is required for a reference");
                }
                return new RuntimeBeanReference(beanRef, true);
            }
            return new RuntimeBeanReference(beanRef);
        }
        if (ele.getTagName().equals(IDREF_ELEMENT)) {
            String beanRef = ele.getAttribute("bean");
            if (!StringUtils.hasLength(beanRef) && !StringUtils.hasLength(beanRef = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, "Either 'bean' or 'local' is required for an idref");
            }
            return beanRef;
        }
        if (ele.getTagName().equals("value")) {
            String value = DomUtils.getTextValue(ele);
            if (ele.hasAttribute(TYPE_ATTRIBUTE)) {
                String typeClassName = ele.getAttribute(TYPE_ATTRIBUTE);
                try {
                    Class typeClass = ClassUtils.forName(typeClassName, this.beanDefinitionReader.getBeanClassLoader());
                    return new TypedStringValue(value, typeClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanDefinitionStoreException(this.getResource(), beanName, "Value type class [" + typeClassName + "] not found", (Throwable)ex);
                }
            }
            return value;
        }
        if (ele.getTagName().equals(NULL_ELEMENT)) {
            return null;
        }
        if (ele.getTagName().equals(LIST_ELEMENT)) {
            return this.parseListElement(ele, beanName);
        }
        if (ele.getTagName().equals(SET_ELEMENT)) {
            return this.parseSetElement(ele, beanName);
        }
        if (ele.getTagName().equals(MAP_ELEMENT)) {
            return this.parseMapElement(ele, beanName);
        }
        if (ele.getTagName().equals(PROPS_ELEMENT)) {
            return this.parsePropsElement(ele, beanName);
        }
        throw new BeanDefinitionStoreException(this.getResource(), beanName, "Unknown property sub-element: <" + ele.getTagName() + ">");
    }

    protected List parseListElement(Element collectionEle, String beanName) throws BeanDefinitionStoreException {
        NodeList nl = collectionEle.getChildNodes();
        ManagedList list = new ManagedList(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            list.add(this.parsePropertySubElement(ele, beanName));
        }
        return list;
    }

    protected Set parseSetElement(Element collectionEle, String beanName) throws BeanDefinitionStoreException {
        NodeList nl = collectionEle.getChildNodes();
        ManagedSet set = new ManagedSet(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            set.add(this.parsePropertySubElement(ele, beanName));
        }
        return set;
    }

    protected Map parseMapElement(Element mapEle, String beanName) throws BeanDefinitionStoreException {
        List entryEles = DomUtils.getChildElementsByTagName(mapEle, ENTRY_ELEMENT);
        ManagedMap map = new ManagedMap(entryEles.size());
        Iterator it = entryEles.iterator();
        while (it.hasNext()) {
            Element entryEle = (Element)it.next();
            NodeList entrySubNodes = entryEle.getChildNodes();
            Element keyEle = null;
            Element valueEle = null;
            for (int j = 0; j < entrySubNodes.getLength(); ++j) {
                if (!(entrySubNodes.item(j) instanceof Element)) continue;
                Element candidateEle = (Element)entrySubNodes.item(j);
                if (candidateEle.getTagName().equals("key")) {
                    if (keyEle != null) {
                        throw new BeanDefinitionStoreException(this.getResource(), beanName, "<entry> is only allowed to contain one <key> sub-element");
                    }
                    keyEle = candidateEle;
                    continue;
                }
                if (valueEle != null) {
                    throw new BeanDefinitionStoreException(this.getResource(), beanName, "<entry> must not contain more than one value sub-element");
                }
                valueEle = candidateEle;
            }
            Object key = null;
            boolean hasKeyAttribute = entryEle.hasAttribute("key");
            boolean hasKeyRefAttribute = entryEle.hasAttribute(KEY_REF_ATTRIBUTE);
            if (hasKeyAttribute && hasKeyRefAttribute || (hasKeyAttribute || hasKeyRefAttribute) && keyEle != null) {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, "<entry> is only allowed to contain either a 'key' attribute OR a 'key-ref' attribute OR a <key> sub-element");
            }
            if (hasKeyAttribute) {
                key = entryEle.getAttribute("key");
            } else if (hasKeyRefAttribute) {
                key = new RuntimeBeanReference(entryEle.getAttribute(KEY_REF_ATTRIBUTE));
            } else if (keyEle != null) {
                key = this.parseKeyElement(keyEle, beanName);
            } else {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, "<entry> must specify a key");
            }
            Object value = null;
            boolean hasValueAttribute = entryEle.hasAttribute("value");
            boolean hasValueRefAttribute = entryEle.hasAttribute(VALUE_REF_ATTRIBUTE);
            if (hasValueAttribute && hasValueRefAttribute || (hasValueAttribute || hasValueRefAttribute) && valueEle != null) {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, "<entry> is only allowed to contain either a 'value' attribute OR a 'value-ref' attribute OR a value sub-element");
            }
            if (hasValueAttribute) {
                value = entryEle.getAttribute("value");
            } else if (hasValueRefAttribute) {
                value = new RuntimeBeanReference(entryEle.getAttribute(VALUE_REF_ATTRIBUTE));
            } else if (valueEle != null) {
                value = this.parsePropertySubElement(valueEle, beanName);
            } else {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, "<entry> must specify a value");
            }
            map.put(key, value);
        }
        return map;
    }

    protected Object parseKeyElement(Element keyEle, String beanName) throws BeanDefinitionStoreException {
        NodeList nl = keyEle.getChildNodes();
        Element subElement = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element candidateEle = (Element)nl.item(i);
            if (subElement != null) {
                throw new BeanDefinitionStoreException(this.getResource(), beanName, "<key> must not contain more than one value sub-element");
            }
            subElement = candidateEle;
        }
        return this.parsePropertySubElement(subElement, beanName);
    }

    protected Properties parsePropsElement(Element propsEle, String beanName) throws BeanDefinitionStoreException {
        Properties props = new Properties();
        List propEles = DomUtils.getChildElementsByTagName(propsEle, PROP_ELEMENT);
        Iterator it = propEles.iterator();
        while (it.hasNext()) {
            Element propEle = (Element)it.next();
            String key = propEle.getAttribute("key");
            String value = DomUtils.getTextValue(propEle).trim();
            props.setProperty(key, value);
        }
        return props;
    }
}

