/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.aop.target.ThreadLocalTargetSourceStats;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;

public final class ThreadLocalTargetSource
extends AbstractPrototypeBasedTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private final ThreadLocal targetInThread = new ThreadLocal();
    private final Set targetSet = Collections.synchronizedSet(new HashSet());
    private int invocationCount;
    private int hitCount;
    static /* synthetic */ Class class$org$springframework$aop$target$ThreadLocalTargetSourceStats;

    public Object getTarget() throws BeansException {
        ++this.invocationCount;
        Object target = this.targetInThread.get();
        if (target == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No target for prototype '" + this.getTargetBeanName() + "' found in thread: " + "creating one and binding it to thread '" + Thread.currentThread().getName() + "'"));
            }
            target = this.newPrototypeInstance();
            this.targetInThread.set(target);
            this.targetSet.add(target);
        } else {
            ++this.hitCount;
        }
        return target;
    }

    public void destroy() {
        this.logger.info((Object)"Destroying ThreadLocalTargetSource bindings");
        Iterator it = this.targetSet.iterator();
        while (it.hasNext()) {
            Object target = it.next();
            if (!(target instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)target).destroy();
            }
            catch (Exception ex) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Thread-bound target of class [" + target.getClass() + "] threw exception from destroy() method"), (Throwable)ex);
            }
        }
        this.targetSet.clear();
        this.targetInThread.set(null);
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getObjectCount() {
        return this.targetSet.size();
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, class$org$springframework$aop$target$ThreadLocalTargetSourceStats == null ? (class$org$springframework$aop$target$ThreadLocalTargetSourceStats = ThreadLocalTargetSource.class$("org.springframework.aop.target.ThreadLocalTargetSourceStats")) : class$org$springframework$aop$target$ThreadLocalTargetSourceStats);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

