/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.object.SqlOperation;

public abstract class SqlQuery
extends SqlOperation {
    private int rowsExpected = 0;

    public SqlQuery() {
    }

    public SqlQuery(DataSource ds, String sql) {
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public void setRowsExpected(int rowsExpected) {
        this.rowsExpected = rowsExpected;
    }

    public int getRowsExpected() {
        return this.rowsExpected;
    }

    public List execute(Object[] params, Map context) throws DataAccessException {
        this.validateParameters(params);
        ResultReader rr = this.newResultReader(this.getRowsExpected(), params, context);
        return this.getJdbcTemplate().query(this.newPreparedStatementCreator(params), (RowCallbackHandler)rr);
    }

    public List execute(Object[] params) throws DataAccessException {
        return this.execute(params, null);
    }

    public List execute(Map context) throws DataAccessException {
        return this.execute((Object[])null, context);
    }

    public List execute() throws DataAccessException {
        return this.execute((Object[])null);
    }

    public List execute(int p1, Map context) throws DataAccessException {
        return this.execute(new Object[]{new Integer(p1)}, context);
    }

    public List execute(int p1) throws DataAccessException {
        return this.execute(p1, (Map)null);
    }

    public List execute(int p1, int p2, Map context) throws DataAccessException {
        return this.execute(new Object[]{new Integer(p1), new Integer(p2)}, context);
    }

    public List execute(int p1, int p2) throws DataAccessException {
        return this.execute(p1, p2, null);
    }

    public List execute(long p1, Map context) throws DataAccessException {
        return this.execute(new Object[]{new Long(p1)}, context);
    }

    public List execute(long p1) throws DataAccessException {
        return this.execute(p1, null);
    }

    public List execute(String p1, Map context) throws DataAccessException {
        return this.execute(new Object[]{p1}, context);
    }

    public List execute(String p1) throws DataAccessException {
        return this.execute(p1, null);
    }

    public Object findObject(Object[] params, Map context) throws DataAccessException {
        List results = this.execute(params, context);
        return DataAccessUtils.singleResult(results);
    }

    public Object findObject(Object[] params) throws DataAccessException {
        return this.findObject(params, null);
    }

    public Object findObject(int p1, Map context) throws DataAccessException {
        return this.findObject(new Object[]{new Integer(p1)}, context);
    }

    public Object findObject(int p1) throws DataAccessException {
        return this.findObject(p1, (Map)null);
    }

    public Object findObject(int p1, int p2, Map context) throws DataAccessException {
        return this.findObject(new Object[]{new Integer(p1), new Integer(p2)}, context);
    }

    public Object findObject(int p1, int p2) throws DataAccessException {
        return this.findObject(p1, p2, null);
    }

    public Object findObject(long p1, Map context) throws DataAccessException {
        return this.findObject(new Object[]{new Long(p1)}, context);
    }

    public Object findObject(long p1) throws DataAccessException {
        return this.findObject(p1, null);
    }

    public Object findObject(String p1, Map context) throws DataAccessException {
        return this.findObject(new Object[]{p1}, context);
    }

    public Object findObject(String p1) throws DataAccessException {
        return this.findObject(p1, null);
    }

    protected abstract ResultReader newResultReader(int var1, Object[] var2, Map var3);
}

