/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractBeanFactory
implements ConfigurableBeanFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanFactory parentBeanFactory;
    private Map customEditors = new HashMap();
    private final List beanPostProcessors = new ArrayList();
    private boolean hasDestructionAwareBeanPostProcessors;
    private final Map aliasMap = new HashMap();
    private final Map singletonCache = CollectionFactory.createLinkedMapIfPossible(16);
    private final Set currentlyInCreation = Collections.synchronizedSet(new HashSet());
    private final Map disposableBeans = CollectionFactory.createLinkedMapIfPossible(16);
    private final Map dependentBeanMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanCurrentlyInCreationException;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBeanNotInitializedException;

    public AbstractBeanFactory() {
    }

    public AbstractBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, null, null);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBean(name, requiredType, null);
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        return this.getBean(name, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String name, Class requiredType, Object[] args) throws BeansException {
        String beanName = this.transformedBeanName(name);
        Object bean = null;
        Object sharedInstance = null;
        Map map = this.singletonCache;
        synchronized (map) {
            sharedInstance = this.singletonCache.get(beanName);
        }
        if (sharedInstance != null) {
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning eagerly cached instance of singleton bean '" + beanName + "' that is not fully initialized yet - a consequence of a circular reference"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning cached instance of singleton bean '" + beanName + "'"));
            }
            bean = this.getObjectForSharedInstance(name, sharedInstance);
        } else {
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            if (this.getParentBeanFactory() != null && !this.containsBeanDefinition(beanName)) {
                if (this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                    return ((AbstractBeanFactory)this.getParentBeanFactory()).getBean(name, requiredType, args);
                }
                if (args == null) {
                    return this.getParentBeanFactory().getBean(name, requiredType);
                }
                throw new NoSuchBeanDefinitionException(beanName, "Cannot delegate to parent BeanFactory because it does not supported passed-in arguments");
            }
            RootBeanDefinition mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
            this.checkMergedBeanDefinition(mergedBeanDefinition, beanName, requiredType, args);
            if (mergedBeanDefinition.isSingleton()) {
                Map map2 = this.singletonCache;
                synchronized (map2) {
                    sharedInstance = this.singletonCache.get(beanName);
                    if (sharedInstance == null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Creating shared instance of singleton bean '" + beanName + "'"));
                        }
                        this.currentlyInCreation.add(beanName);
                        try {
                            sharedInstance = this.createBean(beanName, mergedBeanDefinition, args);
                            this.addSingleton(beanName, sharedInstance);
                        }
                        catch (BeansException ex) {
                            this.destroyDisposableBean(beanName);
                            throw ex;
                        }
                        finally {
                            this.currentlyInCreation.remove(beanName);
                        }
                    }
                }
                bean = this.getObjectForSharedInstance(name, sharedInstance);
            } else {
                bean = this.createBean(beanName, mergedBeanDefinition, args);
            }
        }
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public boolean containsBean(String name) {
        if (this.containsLocalBean(name)) {
            return true;
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null) {
            return parentBeanFactory.containsBean(name);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Class beanClass = null;
        boolean singleton = true;
        Object beanInstance = null;
        Map map = this.singletonCache;
        synchronized (map) {
            beanInstance = this.singletonCache.get(beanName);
        }
        if (beanInstance != null) {
            beanClass = beanInstance.getClass();
            singleton = true;
        } else {
            if (this.getParentBeanFactory() != null && !this.containsBeanDefinition(beanName)) {
                return this.getParentBeanFactory().isSingleton(name);
            }
            RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
            if (bd.hasBeanClass()) {
                beanClass = bd.getBeanClass();
            }
            singleton = bd.isSingleton();
        }
        if (beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !this.isFactoryDereference(name)) {
            FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
            return factoryBean.isSingleton();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getType(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            Class beanClass = null;
            Object beanInstance = null;
            Map map = this.singletonCache;
            synchronized (map) {
                beanInstance = this.singletonCache.get(beanName);
            }
            if (beanInstance != null) {
                beanClass = beanInstance.getClass();
            } else {
                if (this.getParentBeanFactory() != null && !this.containsBeanDefinition(beanName)) {
                    return this.getParentBeanFactory().getType(name);
                }
                RootBeanDefinition mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
                if (mergedBeanDefinition.getFactoryMethodName() != null) {
                    return this.getTypeForFactoryMethod(name, mergedBeanDefinition);
                }
                if (!mergedBeanDefinition.hasBeanClass()) {
                    return null;
                }
                beanClass = mergedBeanDefinition.getBeanClass();
            }
            if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !this.isFactoryDereference(name)) {
                FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
                return factoryBean.getObjectType();
            }
            return beanClass;
        }
        catch (BeanCreationException ex) {
            if (ex.contains(class$org$springframework$beans$factory$BeanCurrentlyInCreationException == null ? (class$org$springframework$beans$factory$BeanCurrentlyInCreationException = AbstractBeanFactory.class$("org.springframework.beans.factory.BeanCurrentlyInCreationException")) : class$org$springframework$beans$factory$BeanCurrentlyInCreationException) || ex.contains(class$org$springframework$beans$factory$FactoryBeanNotInitializedException == null ? (class$org$springframework$beans$factory$FactoryBeanNotInitializedException = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBeanNotInitializedException")) : class$org$springframework$beans$factory$FactoryBeanNotInitializedException)) {
                this.logger.debug((Object)"Ignoring BeanCreationException on FactoryBean type check", (Throwable)ex);
                return null;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        if (this.containsSingleton(beanName) || this.containsBeanDefinition(beanName)) {
            ArrayList aliases = new ArrayList();
            Map map = this.aliasMap;
            synchronized (map) {
                Iterator it = this.aliasMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!entry.getValue().equals(beanName)) continue;
                    aliases.add(entry.getKey());
                }
            }
            return StringUtils.toStringArray(aliases);
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null) {
            return parentBeanFactory.getAliases(name);
        }
        throw new NoSuchBeanDefinitionException(beanName, this.toString());
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public boolean containsLocalBean(String name) {
        String beanName = this.transformedBeanName(name);
        return this.containsSingleton(beanName) || this.containsBeanDefinition(beanName);
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) {
        if (this.parentBeanFactory != null && this.parentBeanFactory != parentBeanFactory) {
            throw new IllegalStateException("Already associated with parent BeanFactory: " + this.parentBeanFactory);
        }
        this.parentBeanFactory = parentBeanFactory;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        Assert.notNull(requiredType, "Required type must not be null");
        Assert.notNull(propertyEditor, "PropertyEditor must not be null");
        this.customEditors.put(requiredType, propertyEditor);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        Assert.notNull(beanPostProcessor, "BeanPostProcessor must not be null");
        this.beanPostProcessors.add(beanPostProcessor);
        if (beanPostProcessor instanceof DestructionAwareBeanPostProcessor) {
            this.hasDestructionAwareBeanPostProcessors = true;
        }
    }

    public int getBeanPostProcessorCount() {
        return this.beanPostProcessors.size();
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    protected boolean hasDestructionAwareBeanPostProcessors() {
        return this.hasDestructionAwareBeanPostProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.hasText(alias, "Alias must not be empty");
        if (!alias.equals(beanName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering alias '" + alias + "' for bean with name '" + beanName + "'"));
            }
            Map map = this.aliasMap;
            synchronized (map) {
                Object registeredName = this.aliasMap.get(alias);
                if (registeredName != null && !registeredName.equals(beanName)) {
                    throw new BeanDefinitionStoreException("Cannot register alias '" + alias + "' for bean name '" + beanName + "': It's already registered for bean name '" + registeredName + "'.");
                }
                this.aliasMap.put(alias, beanName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSingleton(String beanName, Object singletonObject) throws BeanDefinitionStoreException {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(singletonObject, "Singleton object must not be null");
        Map map = this.singletonCache;
        synchronized (map) {
            Object oldObject = this.singletonCache.get(beanName);
            if (oldObject != null) {
                throw new BeanDefinitionStoreException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there's already object [" + oldObject + " bound");
            }
            this.addSingleton(beanName, singletonObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSingleton(String beanName, Object singletonObject) {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(singletonObject, "Singleton object must not be null");
        Map map = this.singletonCache;
        synchronized (map) {
            this.singletonCache.put(beanName, singletonObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSingleton(String beanName) {
        Assert.hasText(beanName, "Bean name must not be empty");
        Map map = this.singletonCache;
        synchronized (map) {
            this.singletonCache.remove(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSingletonCount() {
        Map map = this.singletonCache;
        synchronized (map) {
            return this.singletonCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonNames() {
        Map map = this.singletonCache;
        synchronized (map) {
            return StringUtils.toStringArray(this.singletonCache.keySet());
        }
    }

    protected boolean isSingletonCurrentlyInCreation(String beanName) {
        return this.currentlyInCreation.contains(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSingleton(String beanName) {
        Assert.hasText(beanName, "Bean name must not be empty");
        Map map = this.singletonCache;
        synchronized (map) {
            return this.singletonCache.containsKey(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying singletons in factory {" + this + "}"));
        }
        Map map = this.singletonCache;
        synchronized (map) {
            Map map2 = this.disposableBeans;
            synchronized (map2) {
                String[] disposableBeanNames = StringUtils.toStringArray(this.disposableBeans.keySet());
                for (int i = 0; i < disposableBeanNames.length; ++i) {
                    this.destroyDisposableBean(disposableBeanNames[i]);
                }
            }
            this.singletonCache.clear();
        }
    }

    protected boolean isFactoryDereference(String name) {
        return BeanFactoryUtils.isFactoryDereference(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String transformedBeanName(String name) {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Map map = this.aliasMap;
        synchronized (map) {
            String canonicalName = beanName;
            String resolvedName = null;
            do {
                if ((resolvedName = (String)this.aliasMap.get(canonicalName)) == null) continue;
                canonicalName = resolvedName;
            } while (resolvedName != null);
            return canonicalName;
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        Iterator it = this.getCustomEditors().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Class clazz = (Class)entry.getKey();
            PropertyEditor editor = (PropertyEditor)entry.getValue();
            bw.registerCustomEditor(clazz, editor);
        }
    }

    protected Object doTypeConversionIfNecessary(Object value, Class targetType) throws TypeMismatchException {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.initBeanWrapper(bw);
        return this.doTypeConversionIfNecessary(value, targetType, bw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doTypeConversionIfNecessary(Object value, Class targetType, BeanWrapperImpl bw) throws TypeMismatchException {
        if (!this.getCustomEditors().isEmpty()) {
            Map map = this.getCustomEditors();
            synchronized (map) {
                return bw.doTypeConversionIfNecessary(value, targetType);
            }
        }
        return bw.doTypeConversionIfNecessary(value, targetType);
    }

    public RootBeanDefinition getMergedBeanDefinition(String name) throws BeansException {
        return this.getMergedBeanDefinition(name, false);
    }

    protected RootBeanDefinition getMergedBeanDefinition(String name, boolean includingAncestors) throws BeansException {
        String beanName = this.transformedBeanName(name);
        if (includingAncestors && !this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(beanName, true);
        }
        return this.getMergedBeanDefinition(beanName, this.getBeanDefinition(beanName));
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd) throws BeanDefinitionStoreException {
        if (bd instanceof RootBeanDefinition) {
            return (RootBeanDefinition)bd;
        }
        if (bd instanceof ChildBeanDefinition) {
            RootBeanDefinition pbd;
            ChildBeanDefinition cbd;
            block8: {
                cbd = (ChildBeanDefinition)bd;
                pbd = null;
                try {
                    if (!beanName.equals(cbd.getParentName())) {
                        pbd = this.getMergedBeanDefinition(cbd.getParentName(), true);
                        break block8;
                    }
                    if (this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                        AbstractBeanFactory parentFactory = (AbstractBeanFactory)this.getParentBeanFactory();
                        pbd = parentFactory.getMergedBeanDefinition(cbd.getParentName(), true);
                        break block8;
                    }
                    throw new NoSuchBeanDefinitionException(cbd.getParentName(), "Parent name '" + cbd.getParentName() + "' is equal to bean name '" + beanName + "': cannot be resolved without an AbstractBeanFactory parent");
                }
                catch (NoSuchBeanDefinitionException ex) {
                    throw new BeanDefinitionStoreException(cbd.getResourceDescription(), beanName, "Could not resolve parent bean definition '" + cbd.getParentName() + "'", (Throwable)ex);
                }
            }
            RootBeanDefinition rbd = new RootBeanDefinition(pbd);
            rbd.overrideFrom(cbd);
            try {
                rbd.validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(rbd.getResourceDescription(), beanName, "Validation of bean definition failed", (Throwable)ex);
            }
            return rbd;
        }
        throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Definition is neither a RootBeanDefinition nor a ChildBeanDefinition");
    }

    protected void checkMergedBeanDefinition(RootBeanDefinition mergedBeanDefinition, String beanName, Class requiredType, Object[] args) throws BeansException {
        if (mergedBeanDefinition.isAbstract()) {
            throw new BeanIsAbstractException(beanName);
        }
        if (mergedBeanDefinition.hasBeanClass()) {
            Class beanClass = mergedBeanDefinition.getBeanClass();
            if (requiredType != null && mergedBeanDefinition.getFactoryMethodName() == null && !(class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !requiredType.isAssignableFrom(beanClass)) {
                throw new BeanNotOfRequiredTypeException(beanName, requiredType, beanClass);
            }
        }
        if (args != null) {
            if (mergedBeanDefinition.isSingleton()) {
                throw new BeanDefinitionStoreException("Cannot specify arguments in the getBean() method when referring to a singleton bean definition");
            }
            if (mergedBeanDefinition.getFactoryMethodName() == null) {
                throw new BeanDefinitionStoreException("Can only specify arguments in the getBean() method in conjunction with a factory method");
            }
        }
    }

    protected Object getObjectForSharedInstance(String name, Object beanInstance) throws BeansException {
        String beanName = this.transformedBeanName(name);
        if (this.isFactoryDereference(name) && !(beanInstance instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, beanInstance.getClass());
        }
        if (beanInstance instanceof FactoryBean) {
            if (!this.isFactoryDereference(name)) {
                FactoryBean factory = (FactoryBean)beanInstance;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Bean with name '" + beanName + "' is a factory bean"));
                }
                try {
                    beanInstance = factory.getObject();
                }
                catch (Exception ex) {
                    throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
                }
                if (beanInstance == null) {
                    throw new FactoryBeanNotInitializedException(beanName, "FactoryBean returned null object: probably not fully initialized (maybe due to circular bean reference)");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Calling code asked for FactoryBean instance for name '" + beanName + "'"));
            }
        }
        return beanInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFactoryBean(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Map map = this.singletonCache;
        synchronized (map) {
            Object beanInstance = this.singletonCache.get(beanName);
            if (beanInstance != null) {
                return beanInstance instanceof FactoryBean;
            }
        }
        if (!this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).isFactoryBean(name);
        }
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
        return bd.hasBeanClass() && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).equals(bd.getBeanClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDisposableBeanIfNecessary(final String beanName, final Object bean, final RootBeanDefinition mergedBeanDefinition) {
        if (mergedBeanDefinition.isSingleton()) {
            String[] dependsOn;
            boolean hasDestroyMethod;
            final boolean isDisposableBean = bean instanceof DisposableBean;
            boolean bl = hasDestroyMethod = mergedBeanDefinition.getDestroyMethodName() != null;
            if (isDisposableBean || hasDestroyMethod || this.hasDestructionAwareBeanPostProcessors()) {
                int counter = 1;
                String id = beanName;
                Map map = this.disposableBeans;
                synchronized (map) {
                    while (this.disposableBeans.containsKey(id)) {
                        id = beanName + "#" + ++counter;
                    }
                }
                this.registerDisposableBean(id, new DisposableBean(){

                    public void destroy() throws Exception {
                        if (AbstractBeanFactory.this.hasDestructionAwareBeanPostProcessors()) {
                            if (AbstractBeanFactory.this.logger.isDebugEnabled()) {
                                AbstractBeanFactory.this.logger.debug((Object)("Applying DestructionAwareBeanPostProcessors to bean with name '" + beanName + "'"));
                            }
                            for (int i = AbstractBeanFactory.this.getBeanPostProcessors().size() - 1; i >= 0; --i) {
                                Object beanProcessor = AbstractBeanFactory.this.getBeanPostProcessors().get(i);
                                if (!(beanProcessor instanceof DestructionAwareBeanPostProcessor)) continue;
                                ((DestructionAwareBeanPostProcessor)beanProcessor).postProcessBeforeDestruction(bean, beanName);
                            }
                        }
                        if (isDisposableBean) {
                            if (AbstractBeanFactory.this.logger.isDebugEnabled()) {
                                AbstractBeanFactory.this.logger.debug((Object)("Invoking destroy() on bean with name '" + beanName + "'"));
                            }
                            ((DisposableBean)bean).destroy();
                        }
                        if (hasDestroyMethod) {
                            if (AbstractBeanFactory.this.logger.isDebugEnabled()) {
                                AbstractBeanFactory.this.logger.debug((Object)("Invoking custom destroy method on bean with name '" + beanName + "'"));
                            }
                            AbstractBeanFactory.this.invokeCustomDestroyMethod(beanName, bean, mergedBeanDefinition.getDestroyMethodName(), mergedBeanDefinition.isEnforceDestroyMethod());
                        }
                    }
                });
            }
            if ((dependsOn = mergedBeanDefinition.getDependsOn()) != null) {
                for (int i = 0; i < dependsOn.length; ++i) {
                    this.registerDependentBean(dependsOn[i], beanName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDisposableBean(String beanName, DisposableBean bean) {
        Map map = this.disposableBeans;
        synchronized (map) {
            this.disposableBeans.put(beanName, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDependentBean(String beanName, String dependentBeanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            Set dependencies = (Set)this.dependentBeanMap.get(beanName);
            if (dependencies == null) {
                dependencies = CollectionFactory.createLinkedSetIfPossible(8);
                this.dependentBeanMap.put(beanName, dependencies);
            }
            dependencies.add(dependentBeanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyDisposableBean(String beanName) {
        this.removeSingleton(beanName);
        Object disposableBean = null;
        Map map = this.disposableBeans;
        synchronized (map) {
            disposableBean = this.disposableBeans.remove(beanName);
        }
        this.destroyBean(beanName, disposableBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyBean(String beanName, Object bean) {
        Set dependencies = null;
        Map map = this.dependentBeanMap;
        synchronized (map) {
            dependencies = (Set)this.dependentBeanMap.remove(beanName);
        }
        if (dependencies != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved dependent beans for bean '" + beanName + "': " + dependencies));
            }
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                String dependentBeanName = (String)it.next();
                this.destroyDisposableBean(dependentBeanName);
            }
        }
        if (bean instanceof DisposableBean) {
            try {
                ((DisposableBean)bean).destroy();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Destroy method on bean with name '" + beanName + "' threw an exception"), ex);
            }
        }
    }

    protected void invokeCustomDestroyMethod(String beanName, Object bean, String destroyMethodName, boolean enforceDestroyMethod) {
        Method destroyMethod = BeanUtils.findDeclaredMethodWithMinimalParameters(bean.getClass(), destroyMethodName);
        if (destroyMethod == null) {
            if (enforceDestroyMethod) {
                this.logger.error((Object)("Couldn't find a destroy method named '" + destroyMethodName + "' on bean with name '" + beanName + "'"));
            }
        } else {
            Class<?>[] paramTypes = destroyMethod.getParameterTypes();
            if (paramTypes.length > 1) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has more than one parameter - not supported as destroy method"));
            } else if (paramTypes.length == 1 && !paramTypes[0].equals(Boolean.TYPE)) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has a non-boolean parameter - not supported as destroy method"));
            } else {
                Object[] args = new Object[paramTypes.length];
                if (paramTypes.length == 1) {
                    args[0] = Boolean.TRUE;
                }
                if (!Modifier.isPublic(destroyMethod.getModifiers())) {
                    destroyMethod.setAccessible(true);
                }
                try {
                    destroyMethod.invoke(bean, args);
                }
                catch (InvocationTargetException ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), ex.getTargetException());
                }
                catch (Throwable ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), ex);
                }
            }
        }
    }

    protected abstract boolean containsBeanDefinition(String var1);

    protected abstract BeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract Object createBean(String var1, RootBeanDefinition var2, Object[] var3) throws BeanCreationException;

    protected Class getTypeForFactoryMethod(String beanName, RootBeanDefinition mergedBeanDefinition) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

