/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.servlet.support.SessionRequiredException;

public class MultiActionController
extends AbstractController
implements LastModified {
    public static final String LAST_MODIFIED_METHOD_SUFFIX = "LastModified";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private Validator[] validators;
    private Object delegate;
    private Map handlerMethodMap;
    private Map lastModifiedMethodMap;
    private Map exceptionHandlerMap;
    static /* synthetic */ Class class$org$springframework$web$servlet$ModelAndView;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;

    public MultiActionController() throws ApplicationContextException {
        this.setDelegate(this);
    }

    public MultiActionController(Object delegate) throws ApplicationContextException {
        this.setDelegate(delegate);
    }

    public final void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public final MethodNameResolver getMethodNameResolver() {
        return this.methodNameResolver;
    }

    public final void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    public final Validator[] getValidators() {
        return this.validators;
    }

    public final void setDelegate(Object delegate) throws ApplicationContextException {
        Class<?>[] params;
        int i;
        if (delegate == null) {
            throw new IllegalArgumentException("delegate cannot be <code>null</code> in MultiActionController");
        }
        this.delegate = delegate;
        this.handlerMethodMap = new HashMap();
        this.lastModifiedMethodMap = new HashMap();
        Method[] methods = delegate.getClass().getMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getReturnType().equals(class$org$springframework$web$servlet$ModelAndView == null ? MultiActionController.class$("org.springframework.web.servlet.ModelAndView") : class$org$springframework$web$servlet$ModelAndView) || (params = methods[i].getParameterTypes()).length < 2 || !params[0].equals(class$javax$servlet$http$HttpServletRequest == null ? MultiActionController.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest) || !params[1].equals(class$javax$servlet$http$HttpServletResponse == null ? MultiActionController.class$("javax.servlet.http.HttpServletResponse") : class$javax$servlet$http$HttpServletResponse)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found action method [" + methods[i] + "]"));
            }
            this.handlerMethodMap.put(methods[i].getName(), methods[i]);
            try {
                Method lastModifiedMethod = delegate.getClass().getMethod(methods[i].getName() + LAST_MODIFIED_METHOD_SUFFIX, class$javax$servlet$http$HttpServletRequest == null ? MultiActionController.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest);
                this.lastModifiedMethodMap.put(methods[i].getName(), lastModifiedMethod);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Found last modified method for action method [" + methods[i] + "]"));
                continue;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (this.handlerMethodMap.isEmpty()) {
            throw new ApplicationContextException("No handler methods in class [" + this.getClass().getName() + "]");
        }
        this.exceptionHandlerMap = new HashMap();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getReturnType().equals(class$org$springframework$web$servlet$ModelAndView == null ? MultiActionController.class$("org.springframework.web.servlet.ModelAndView") : class$org$springframework$web$servlet$ModelAndView) || methods[i].getParameterTypes().length != 3 || !(params = methods[i].getParameterTypes())[0].equals(class$javax$servlet$http$HttpServletRequest == null ? MultiActionController.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest) || !params[1].equals(class$javax$servlet$http$HttpServletResponse == null ? MultiActionController.class$("javax.servlet.http.HttpServletResponse") : class$javax$servlet$http$HttpServletResponse) || !(class$java$lang$Throwable == null ? MultiActionController.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(params[2])) continue;
            this.exceptionHandlerMap.put(params[2], methods[i]);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Found exception handler method [" + methods[i] + "]"));
        }
    }

    public final long getLastModified(HttpServletRequest request) {
        try {
            String handlerMethodName = this.methodNameResolver.getHandlerMethodName(request);
            Method lastModifiedMethod = (Method)this.lastModifiedMethodMap.get(handlerMethodName);
            if (lastModifiedMethod != null) {
                try {
                    Long wrappedLong = (Long)lastModifiedMethod.invoke(this.delegate, request);
                    return wrappedLong;
                }
                catch (Exception ex) {
                    this.logger.error((Object)"Failed to invoke lastModified method", (Throwable)ex);
                }
            }
        }
        catch (NoSuchRequestHandlingMethodException noSuchRequestHandlingMethodException) {
            // empty catch block
        }
        return -1L;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String methodName = this.methodNameResolver.getHandlerMethodName(request);
            return this.invokeNamedMethod(methodName, request, response);
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            pageNotFoundLogger.warn((Object)ex.getMessage());
            response.sendError(404);
            return null;
        }
    }

    protected final ModelAndView invokeNamedMethod(String methodName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Method method = (Method)this.handlerMethodMap.get(methodName);
        if (method == null) {
            throw new NoSuchRequestHandlingMethodException(methodName, this.getClass());
        }
        try {
            ArrayList<Object> params = new ArrayList<Object>(4);
            params.add(request);
            params.add(response);
            if (method.getParameterTypes().length >= 3 && method.getParameterTypes()[2].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    return this.handleException(request, response, (Throwable)((Object)new SessionRequiredException("Pre-existing session required for handler method '" + methodName + "'")));
                }
                params.add(session);
            }
            if (method.getParameterTypes().length >= 3 && !method.getParameterTypes()[method.getParameterTypes().length - 1].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                Object command = this.newCommandObject(method.getParameterTypes()[method.getParameterTypes().length - 1]);
                params.add(command);
                this.bind((ServletRequest)request, command);
            }
            return (ModelAndView)method.invoke(this.delegate, params.toArray(new Object[params.size()]));
        }
        catch (InvocationTargetException ex) {
            return this.handleException(request, response, ex.getTargetException());
        }
    }

    protected Object newCommandObject(Class clazz) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Must create new command of class [" + clazz.getName() + "]"));
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ServletException("Cannot instantiate command of class [" + clazz.getName() + "]: Does it have a public no arg constructor?", (Throwable)ex);
        }
    }

    protected void bind(ServletRequest request, Object command) throws Exception {
        this.logger.debug((Object)"Binding request parameters onto MultiActionController command");
        ServletRequestDataBinder binder = this.createBinder(request, command);
        binder.bind(request);
        if (this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (!this.validators[i].supports(command.getClass())) continue;
                ValidationUtils.invokeValidator(this.validators[i], command, binder.getErrors());
            }
        }
        binder.closeNoCatch();
    }

    protected ServletRequestDataBinder createBinder(ServletRequest request, Object command) throws Exception {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(command, DEFAULT_COMMAND_NAME);
        this.initBinder(request, binder);
        return binder;
    }

    protected void initBinder(ServletRequest request, ServletRequestDataBinder binder) throws Exception {
    }

    protected Method getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to find handler for exception class [" + exceptionClass.getName() + "]"));
        }
        Method handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        while (handler == null && !exceptionClass.equals(class$java$lang$Throwable == null ? MultiActionController.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Trying to find handler for exception superclass [" + exceptionClass.getName() + "]"));
            }
            exceptionClass = exceptionClass.getSuperclass();
            handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        }
        return handler;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Throwable ex) throws Exception {
        Method handler = this.getExceptionHandler(ex);
        if (handler != null) {
            return this.invokeExceptionHandler(handler, request, response, ex);
        }
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new ServletException("Unknown Throwable type encountered: " + ex);
    }

    private ModelAndView invokeExceptionHandler(Method handler, HttpServletRequest request, HttpServletResponse response, Throwable ex) throws Exception {
        if (handler == null) {
            throw new ServletException("No handler for exception", ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking exception handler [" + handler + "] for exception [" + ex + "]"));
        }
        try {
            ModelAndView mv = (ModelAndView)handler.invoke(this.delegate, request, response, ex);
            return mv;
        }
        catch (InvocationTargetException ex2) {
            Throwable targetEx = ex2.getTargetException();
            if (targetEx instanceof Exception) {
                throw (Exception)targetEx;
            }
            if (targetEx instanceof Error) {
                throw (Error)targetEx;
            }
            throw new ServletException("Unknown Throwable type encountered", targetEx);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

