/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class RequestHolder {
    public static ThreadLocal currentRequest = new ThreadLocal();

    public static void bind(HttpServletRequest request) {
        currentRequest.set(request);
    }

    public static void clear() {
        currentRequest.set(null);
    }

    public static HttpServletRequest currentRequest() throws IllegalStateException {
        HttpServletRequest request = (HttpServletRequest)currentRequest.get();
        if (request == null) {
            throw new IllegalStateException("No thread-bound request: Try using RequestBindingFilter");
        }
        return request;
    }

    public static HttpSession currentSession() {
        return RequestHolder.currentRequest().getSession(true);
    }
}

