/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class MBeanServerConnectionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private JMXServiceURL serviceUrl;
    private Map environment;
    private JMXConnector connector;
    private MBeanServerConnection connection;
    static /* synthetic */ Class class$javax$management$MBeanServerConnection;

    public void setServiceUrl(String url) throws MalformedURLException {
        this.serviceUrl = new JMXServiceURL(url);
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironmentMap(Map environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.serviceUrl == null) {
            throw new IllegalArgumentException("serviceUrl is required");
        }
        this.connector = JMXConnectorFactory.connect(this.serviceUrl, this.environment);
        this.connection = this.connector.getMBeanServerConnection();
    }

    public Object getObject() {
        return this.connection;
    }

    public Class getObjectType() {
        return this.connection != null ? this.connection.getClass() : (class$javax$management$MBeanServerConnection == null ? (class$javax$management$MBeanServerConnection = MBeanServerConnectionFactoryBean.class$("javax.management.MBeanServerConnection")) : class$javax$management$MBeanServerConnection);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws IOException {
        this.connector.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

