/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.jmx.export.assembler.AutodetectCapableMBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.SimpleReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.naming.KeyNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.JmxUtils;

public class MBeanExporter
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MBeanServer server;
    private Map beans;
    private boolean autodetect = false;
    private MBeanInfoAssembler assembler = new SimpleReflectiveMBeanInfoAssembler();
    private ObjectNamingStrategy namingStrategy = new KeyNamingStrategy();
    private ListableBeanFactory beanFactory;
    private Set registeredBeans;

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setBeans(Map beans) {
        this.beans = beans;
    }

    public void setAutodetect(boolean autodetect) {
        this.autodetect = autodetect;
    }

    public void setAssembler(MBeanInfoAssembler assembler) {
        this.assembler = assembler;
    }

    public void setNamingStrategy(ObjectNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        } else {
            this.logger.info((Object)"Not running in a ListableBeanFactory: autodetection of MBeans not available");
        }
    }

    public void afterPropertiesSet() throws JMException {
        this.registerBeans();
    }

    protected void registerBeans() throws JMException {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        if (this.beans == null) {
            this.beans = new HashMap();
        }
        if (this.autodetect) {
            if (this.beanFactory == null) {
                throw new JMException("Cannot autodetect MBeans if not running in a BeanFactory");
            }
            this.logger.info((Object)"Autodetecting user-defined JMX MBeans");
            this.autodetectMBeans();
            if (this.assembler instanceof AutodetectCapableMBeanInfoAssembler) {
                this.autodetectBeans((AutodetectCapableMBeanInfoAssembler)this.assembler);
            }
        }
        if (this.beans.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one bean for registration");
        }
        this.registeredBeans = new HashSet(this.beans.size());
        try {
            Iterator it = this.beans.entrySet().iterator();
            while (it.hasNext()) {
                Object value;
                Map.Entry entry = it.next();
                String beanKey = (String)entry.getKey();
                ObjectName objectName = this.registerBeanNameOrInstance(beanKey, value = entry.getValue());
                if (objectName == null) continue;
                this.registeredBeans.add(objectName);
            }
        }
        catch (InvalidTargetObjectTypeException ex) {
            this.unregisterBeans();
            throw new JMException("An invalid object type was used when specifying a managed resource. This is a serious error and points to an error in the Spring JMX code. Root cause: " + ex.getMessage());
        }
        catch (JMException ex) {
            this.unregisterBeans();
            throw ex;
        }
    }

    private ObjectName registerBeanNameOrInstance(String beanKey, Object mapValue) throws JMException, InvalidTargetObjectTypeException {
        if (mapValue instanceof String) {
            if (this.beanFactory == null) {
                throw new JMException("Cannot resolve bean names if not running in a BeanFactory");
            }
            String beanName = (String)mapValue;
            if (this.isBeanDefinitionLazyInit(this.beanFactory, beanName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found bean name for lazy init bean with key [" + beanKey + "]. Registering bean with lazy init support."));
                }
                return this.registerLazyInit(beanKey, beanName);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("String value under key [" + beanKey + "] points to a bean that was not " + "registered for lazy initialization. Registering bean normally with JMX server."));
            }
            Object bean = this.beanFactory.getBean(beanName);
            return this.registerBeanInstance(beanKey, bean);
        }
        return this.registerBeanInstance(beanKey, mapValue);
    }

    private ObjectName registerBeanInstance(String beanKey, Object beanInstance) throws JMException, InvalidTargetObjectTypeException {
        if (JmxUtils.isMBean(beanInstance.getClass())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Located MBean under key [" + beanKey + "]: registering with JMX server"));
            }
            return this.registerMBean(beanKey, beanInstance);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Located bean under key [" + beanKey + "] registering with JMX server."));
        }
        return this.registerSimpleBean(beanKey, beanInstance);
    }

    private ObjectName registerMBean(String beanKey, Object mbean) throws JMException {
        try {
            ObjectName objectName = this.namingStrategy.getObjectName(mbean, beanKey);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering MBean [" + objectName + "]"));
            }
            this.server.registerMBean(mbean, objectName);
            return objectName;
        }
        catch (MalformedObjectNameException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to auto-register MBean [" + mbean + "] with key [" + beanKey + "]"));
            }
            return null;
        }
    }

    private ObjectName registerSimpleBean(String beanKey, Object bean) throws JMException, InvalidTargetObjectTypeException {
        ObjectName objectName = this.namingStrategy.getObjectName(bean, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering and assembling MBean [" + objectName + "]"));
        }
        ModelMBean mbean = this.createModelMBean();
        Class beanClass = this.getBeanClass(bean);
        mbean.setModelMBeanInfo(this.getMBeanInfo(beanKey, beanClass));
        mbean.setManagedResource(bean, "ObjectReference");
        this.server.registerMBean(mbean, objectName);
        return objectName;
    }

    private ObjectName registerLazyInit(String beanKey, String beanName) throws JMException, InvalidTargetObjectTypeException {
        LazyInitTargetSource targetSource = new LazyInitTargetSource();
        targetSource.setTargetBeanName(beanName);
        targetSource.setBeanFactory(this.beanFactory);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(targetSource);
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setFrozen(true);
        Object proxy = proxyFactory.getProxy();
        ObjectName objectName = this.namingStrategy.getObjectName(proxy, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering lazy-init MBean [" + objectName + "]"));
        }
        ModelMBean mbean = this.createModelMBean();
        mbean.setModelMBeanInfo(this.getMBeanInfo(beanKey, targetSource.getTargetClass()));
        mbean.setManagedResource(proxy, "ObjectReference");
        this.server.registerMBean(mbean, objectName);
        return objectName;
    }

    private ModelMBeanInfo getMBeanInfo(String beanKey, Class beanClass) throws JMException {
        ModelMBeanInfo info = this.assembler.getMBeanInfo(beanKey, beanClass);
        if (this.logger.isWarnEnabled() && this.isEmpty(info.getAttributes()) && this.isEmpty(info.getOperations())) {
            this.logger.warn((Object)("Bean with key [" + beanKey + "] has been registed as an MBean but has no exposed attributes or operations"));
        }
        return info;
    }

    private boolean isEmpty(MBeanFeatureInfo[] array) {
        return array == null || array.length == 0;
    }

    private void autodetectMBeans() {
        this.autodetect(new AutodetectCallback(){

            public boolean include(String beanName, Class beanClass) {
                return JmxUtils.isMBean(beanClass);
            }
        });
    }

    private void autodetectBeans(final AutodetectCapableMBeanInfoAssembler assembler) {
        this.autodetect(new AutodetectCallback(){

            public boolean include(String beanName, Class beanClass) {
                return beanClass != null && assembler.includeBean(beanName, beanClass);
            }
        });
    }

    private void autodetect(AutodetectCallback callback) {
        String[] beanNames = this.beanFactory.getBeanNamesForType(null);
        for (int i = 0; i < beanNames.length; ++i) {
            Object beanInstance;
            String beanName = beanNames[i];
            Class beanClass = this.beanFactory.getType(beanName);
            if (!callback.include(beanName, beanClass)) continue;
            boolean lazyInit = this.isBeanDefinitionLazyInit(this.beanFactory, beanName);
            Object object = beanInstance = !lazyInit ? this.beanFactory.getBean(beanName) : null;
            if (!(this.beans.containsValue(beanName) || beanInstance != null && this.beans.containsValue(beanInstance))) {
                this.beans.put(beanName, beanInstance != null ? beanInstance : beanName);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Bean with name '" + beanName + "' has been autodetected for JMX exposure"));
                continue;
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.debug((Object)("Bean with name '" + beanName + "' is already registered for JMX exposure"));
        }
    }

    protected boolean isBeanDefinitionLazyInit(ListableBeanFactory beanFactory, String beanName) {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            return false;
        }
        try {
            BeanDefinition bd = ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName);
            return bd.isLazyInit();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    protected Class getBeanClass(Object bean) {
        if (bean instanceof Advised) {
            return ((Advised)bean).getTargetSource().getTargetClass();
        }
        return bean.getClass();
    }

    protected ModelMBean createModelMBean() throws MBeanException {
        return new RequiredModelMBean();
    }

    public void destroy() {
        this.unregisterBeans();
    }

    private void unregisterBeans() {
        this.logger.info((Object)"Unregistering JMX-exposed beans on shutdown");
        Iterator it = this.registeredBeans.iterator();
        while (it.hasNext()) {
            ObjectName objectName = (ObjectName)it.next();
            try {
                this.server.unregisterMBean(objectName);
            }
            catch (JMException ex) {
                this.logger.error((Object)("Could not unregister MBean [" + objectName + "]"), (Throwable)ex);
            }
        }
        this.registeredBeans.clear();
    }

    private static interface AutodetectCallback {
        public boolean include(String var1, Class var2);
    }
}

