/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.jmx.export.assembler.AbstractMBeanInfoAssembler;

public abstract class AbstractReflectiveMBeanInfoAssembler
extends AbstractMBeanInfoAssembler {
    private static final String VISIBILITY = "visibility";
    private static final Integer ATTRIBUTE_OPERATION_VISIBILITY = new Integer(4);
    private static final String ROLE = "role";
    private static final String GETTER = "getter";
    private static final String SETTER = "setter";
    private static final String OPERATION = "operation";
    static /* synthetic */ Class class$java$lang$Object;

    protected ModelMBeanAttributeInfo[] getAttributeInfo(String beanKey, Class beanClass) throws JMException {
        PropertyDescriptor[] props = BeanUtils.getPropertyDescriptors(beanClass);
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        for (int i = 0; i < props.length; ++i) {
            Method setter;
            Method getter = props[i].getReadMethod();
            if (getter != null && getter.getDeclaringClass() == (class$java$lang$Object == null ? AbstractReflectiveMBeanInfoAssembler.class$("java.lang.Object") : class$java$lang$Object)) continue;
            if (getter != null && !this.includeReadAttribute(getter, beanKey)) {
                getter = null;
            }
            if ((setter = props[i].getWriteMethod()) != null && !this.includeWriteAttribute(setter, beanKey)) {
                setter = null;
            }
            if (getter == null && setter == null) continue;
            ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(props[i].getName(), this.getAttributeDescription(props[i]), getter, setter);
            Descriptor desc = info.getDescriptor();
            if (getter != null) {
                desc.setField("getMethod", getter.getName());
            }
            if (setter != null) {
                desc.setField("setMethod", setter.getName());
            }
            this.populateAttributeDescriptor(desc, getter, setter);
            info.setDescriptor(desc);
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanAttributeInfo[infos.size()]);
    }

    protected ModelMBeanOperationInfo[] getOperationInfo(String beanKey, Class beanClass) {
        Method[] methods = beanClass.getMethods();
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        for (int i = 0; i < methods.length; ++i) {
            Descriptor desc;
            Method method = methods[i];
            ModelMBeanOperationInfo info = null;
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? AbstractReflectiveMBeanInfoAssembler.class$("java.lang.Object") : class$java$lang$Object)) continue;
            PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
            if (pd != null) {
                if (method.equals(pd.getReadMethod()) && this.includeReadAttribute(method, beanKey) || method.equals(pd.getWriteMethod()) && this.includeWriteAttribute(method, beanKey)) {
                    info = this.createModelMBeanOperationInfo(method, pd.getName(), true);
                    desc = info.getDescriptor();
                    desc.setField(VISIBILITY, ATTRIBUTE_OPERATION_VISIBILITY);
                    if (method.equals(pd.getReadMethod())) {
                        desc.setField(ROLE, GETTER);
                    } else {
                        desc.setField(ROLE, SETTER);
                    }
                    info.setDescriptor(desc);
                }
            } else if (this.includeOperation(method, beanKey)) {
                info = this.createModelMBeanOperationInfo(method, method.getName(), false);
                desc = info.getDescriptor();
                desc.setField(ROLE, OPERATION);
                this.populateOperationDescriptor(desc, method);
                info.setDescriptor(desc);
            }
            if (info == null) continue;
            infos.add(info);
        }
        return infos.toArray(new ModelMBeanOperationInfo[infos.size()]);
    }

    protected ModelMBeanConstructorInfo[] getConstructorInfo(String beanKey, Class beanClass) {
        return new ModelMBeanConstructorInfo[0];
    }

    protected ModelMBeanNotificationInfo[] getNotificationInfo(String beanKey, Class beanClass) {
        return new ModelMBeanNotificationInfo[0];
    }

    protected MBeanParameterInfo[] getOperationParameters(Method method) {
        return new MBeanParameterInfo[0];
    }

    protected abstract boolean includeReadAttribute(Method var1, String var2);

    protected abstract boolean includeWriteAttribute(Method var1, String var2);

    protected abstract boolean includeOperation(Method var1, String var2);

    protected String getAttributeDescription(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getDisplayName();
    }

    protected String getOperationDescription(Method method) {
        return method.getName();
    }

    protected void populateAttributeDescriptor(Descriptor descriptor, Method getter, Method setter) {
    }

    protected void populateOperationDescriptor(Descriptor descriptor, Method method) {
    }

    private ModelMBeanOperationInfo createModelMBeanOperationInfo(Method method, String name, boolean isAttributeOperation) {
        MBeanParameterInfo[] params = this.getOperationParameters(method);
        if (params.length == 0) {
            return new ModelMBeanOperationInfo(this.getOperationDescription(method), method);
        }
        return new ModelMBeanOperationInfo(name, this.getOperationDescription(method), this.getOperationParameters(method), method.getReturnType().getName(), 3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

