/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.HashMap;
import java.util.Map;
import org.springframework.web.servlet.View;

public class ModelAndView {
    private View view;
    private String viewName;
    private Map model;

    public ModelAndView(View view) {
        this.view = view;
        this.model = new HashMap(0);
    }

    public ModelAndView(String viewName) {
        this.viewName = viewName;
        this.model = new HashMap(0);
    }

    public ModelAndView(View view, Map model) {
        this.view = view;
        this.model = model;
    }

    public ModelAndView(String viewName, Map model) {
        this.viewName = viewName;
        this.model = model;
    }

    public ModelAndView(View view, String modelName, Object modelObject) {
        this.view = view;
        this.model = new HashMap(1);
        this.model.put(modelName, modelObject);
    }

    public ModelAndView(String viewName, String modelName, Object modelObject) {
        this.viewName = viewName;
        this.model = new HashMap(1);
        this.model.put(modelName, modelObject);
    }

    public void setView(View view) {
        this.view = view;
        this.viewName = null;
    }

    public View getView() {
        return this.view;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
        this.view = null;
    }

    public String getViewName() {
        return this.viewName;
    }

    public boolean isReference() {
        return this.viewName != null;
    }

    public Map getModel() {
        return this.model;
    }

    public ModelAndView addObject(String modelName, Object modelObject) {
        this.model.put(modelName, modelObject);
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ModelAndView: ");
        if (this.isReference()) {
            buf.append("reference to view with name '").append(this.viewName).append("'");
        } else {
            buf.append("materialized View is [").append(this.view).append(']');
        }
        buf.append("; model is ").append(this.model);
        return buf.toString();
    }
}

