/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

public abstract class ObjectUtils {
    public static boolean nullSafeEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static String getIdentityHexString(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    public static boolean isCheckedException(Throwable ex) {
        return ex instanceof Exception && !(ex instanceof RuntimeException);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class[] declaredExceptions) {
        if (ex instanceof RuntimeException) {
            return true;
        }
        if (declaredExceptions != null) {
            for (int i = 0; i < declaredExceptions.length; ++i) {
                if (!declaredExceptions[i].isAssignableFrom(ex.getClass())) continue;
                return true;
            }
        }
        return false;
    }
}

