/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyOverrideConfigurer
extends PropertyResourceConfigurer {
    private boolean ignoreInvalidKeys = false;
    private Set beanNames = Collections.synchronizedSet(new HashSet());

    public void setIgnoreInvalidKeys(boolean ignoreInvalidKeys) {
        this.ignoreInvalidKeys = ignoreInvalidKeys;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            try {
                this.processKey(beanFactory, key, props.getProperty(key));
            }
            catch (BeansException ex) {
                String msg = "Could not process key [" + key + "] in PropertyOverrideConfigurer";
                if (this.ignoreInvalidKeys) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)msg, (Throwable)ex);
                        continue;
                    }
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)(msg + ": " + ex.getMessage()));
                    continue;
                }
                throw new BeanInitializationException(msg, ex);
            }
        }
    }

    protected void processKey(ConfigurableListableBeanFactory factory, String key, String value) throws BeansException {
        int dotIndex = key.indexOf(46);
        if (dotIndex == -1) {
            throw new BeanInitializationException("Invalid key [" + key + "]: expected 'beanName.property'");
        }
        String beanName = key.substring(0, dotIndex);
        String beanProperty = key.substring(dotIndex + 1);
        this.beanNames.add(beanName);
        this.applyPropertyValue(factory, beanName, beanProperty, value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Property '" + key + "' set to [" + value + "]"));
        }
    }

    protected void applyPropertyValue(ConfigurableListableBeanFactory factory, String beanName, String property, String value) {
        BeanDefinition bd = factory.getBeanDefinition(beanName);
        bd.getPropertyValues().addPropertyValue(property, value);
    }

    public boolean hasPropertyOverridesFor(String beanName) {
        return this.beanNames.contains(beanName);
    }
}

