/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ContextLoader {
    public static final String CONTEXT_CLASS_PARAM = "contextClass";
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$springframework$web$context$support$XmlWebApplicationContext == null ? (class$org$springframework$web$context$support$XmlWebApplicationContext = ContextLoader.class$("org.springframework.web.context.support.XmlWebApplicationContext")) : class$org$springframework$web$context$support$XmlWebApplicationContext;
    public static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";
    private final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$context$ContextLoader == null ? (class$org$springframework$web$context$ContextLoader = ContextLoader.class$("org.springframework.web.context.ContextLoader")) : class$org$springframework$web$context$ContextLoader));
    static /* synthetic */ Class class$org$springframework$web$context$support$XmlWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$ContextLoader;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws BeansException {
        servletContext.log("Loading root WebApplicationContext");
        try {
            ApplicationContext parent = this.loadParentContext(servletContext);
            WebApplicationContext wac = this.createWebApplicationContext(servletContext, parent);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)wac);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using context class [" + wac.getClass().getName() + "] for root WebApplicationContext"));
                this.logger.info((Object)("Published root WebApplicationContext [" + wac + "] as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            return wac;
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            this.logger.error((Object)"Context initialization failed", (Throwable)err);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)err);
            throw err;
        }
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext parent) throws BeansException {
        String contextClassName = servletContext.getInitParameter(CONTEXT_CLASS_PARAM);
        Class<?> contextClass = DEFAULT_CONTEXT_CLASS;
        if (contextClassName != null) {
            try {
                contextClass = Class.forName(contextClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load context class [" + contextClassName + "]", ex);
            }
            if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoader.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(contextClass)) {
                throw new ApplicationContextException("Custom context class [" + contextClassName + "] is not of type ConfigurableWebApplicationContext");
            }
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(contextClass);
        wac.setParent(parent);
        wac.setServletContext(servletContext);
        String configLocation = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (configLocation != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray(configLocation, ",; \t\n", true, true));
        }
        wac.refresh();
        return wac;
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        return null;
    }

    public void closeWebApplicationContext(ServletContext servletContext) throws ApplicationContextException {
        servletContext.log("Closing root WebApplicationContext");
        Object wac = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (wac instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)wac).close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

