/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultReader;
import org.springframework.jdbc.core.SqlParameter;

public class ResultSetSupportingSqlParameter
extends SqlParameter {
    private ResultSetExtractor resultSetExtractor = null;
    private RowCallbackHandler rowCallbackHandler = null;
    private RowMapper rowMapper = null;
    private int rowsExpected = 0;

    public ResultSetSupportingSqlParameter(String name, int type) {
        super(name, type);
    }

    public ResultSetSupportingSqlParameter(String name, int type, String typeName) {
        super(name, type, typeName);
    }

    public ResultSetSupportingSqlParameter(String name, int type, ResultSetExtractor resultSetExtractor) {
        super(name, type);
        this.resultSetExtractor = resultSetExtractor;
    }

    public ResultSetSupportingSqlParameter(String name, int type, RowCallbackHandler rch) {
        super(name, type);
        this.rowCallbackHandler = rch;
    }

    public ResultSetSupportingSqlParameter(String name, int type, RowMapper rm) {
        super(name, type);
        this.rowMapper = rm;
    }

    public ResultSetSupportingSqlParameter(String name, int type, RowMapper rm, int rowsExpected) {
        super(name, type);
        this.rowMapper = rm;
        this.rowsExpected = rowsExpected;
    }

    public boolean isResultSetSupported() {
        return this.resultSetExtractor != null || this.rowCallbackHandler != null || this.rowMapper != null;
    }

    protected boolean isRowCallbackHandlerSupported() {
        return this.rowCallbackHandler != null || this.rowMapper != null;
    }

    protected ResultSetExtractor getResultSetExtractor() {
        return this.resultSetExtractor;
    }

    protected RowCallbackHandler getRowCallbackHandler() {
        if (this.rowMapper != null) {
            return new RowMapperResultReader(this.rowMapper, this.rowsExpected);
        }
        return this.rowCallbackHandler;
    }
}

