/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class BindErrorsTag
extends HtmlEscapingAwareTag {
    public static final String ERRORS_VARIABLE_NAME = "errors";
    private String name;
    private Errors errors;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected final int doStartTagInternal() throws ServletException, JspException {
        String resolvedName = ExpressionEvaluationUtils.evaluateString("name", this.name, this.pageContext);
        this.errors = this.getRequestContext().getErrors(resolvedName, this.isHtmlEscape());
        if (this.errors != null && this.errors.hasErrors()) {
            this.pageContext.setAttribute(ERRORS_VARIABLE_NAME, (Object)this.errors);
            return 1;
        }
        return 0;
    }

    public int doEndTag() {
        this.pageContext.removeAttribute(ERRORS_VARIABLE_NAME);
        return 6;
    }

    public final Errors getErrors() {
        return this.errors;
    }
}

