/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.converter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class SimpleMessageConverter
implements MessageConverter {
    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        if (object instanceof String) {
            return session.createTextMessage((String)object);
        }
        if (object instanceof byte[]) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes((byte[])object);
            return message;
        }
        if (object instanceof Map) {
            MapMessage message = session.createMapMessage();
            Map map = (Map)object;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!(entry.getKey() instanceof String)) {
                    throw new MessageConversionException("Cannot convert non-String key of type [" + (entry.getKey() != null ? entry.getKey().getClass().getName() : null) + "] to MapMessage entry");
                }
                message.setObject((String)entry.getKey(), entry.getValue());
            }
            return message;
        }
        throw new MessageConversionException("Cannot convert object [" + object + "] to JMS message");
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            byte[] bytes = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(bytes);
            return bytes;
        }
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration enumeration = mapMessage.getMapNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                map.put(key, mapMessage.getObject(key));
            }
            return map;
        }
        throw new MessageConversionException("Cannot convert JMS message [" + message + "] to object");
    }
}

