/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class TransactionAwareDataSourceProxy
extends DelegatingDataSource {
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$ConnectionProxy;

    public TransactionAwareDataSourceProxy() {
    }

    public TransactionAwareDataSourceProxy(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
        this.afterPropertiesSet();
    }

    public Connection getConnection() throws SQLException {
        Connection con = DataSourceUtils.doGetConnection(this.getTargetDataSource(), true);
        return this.getTransactionAwareConnectionProxy(con, this.getTargetDataSource());
    }

    protected Connection getTransactionAwareConnectionProxy(Connection target, DataSource ds) {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = TransactionAwareDataSourceProxy.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy}, (InvocationHandler)new TransactionAwareInvocationHandler(target, ds));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private static final String GET_TARGET_CONNECTION_METHOD_NAME = "getTargetConnection";
        private static final String CONNECTION_CLOSE_METHOD_NAME = "close";
        private final Connection target;
        private final DataSource dataSource;

        private TransactionAwareInvocationHandler(Connection target, DataSource dataSource) {
            this.target = target;
            this.dataSource = dataSource;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals(GET_TARGET_CONNECTION_METHOD_NAME)) {
                return this.target;
            }
            if (method.getName().equals(CONNECTION_CLOSE_METHOD_NAME)) {
                if (this.dataSource != null) {
                    DataSourceUtils.doCloseConnectionIfNecessary(this.target, this.dataSource);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

