/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object;
        block10: {
            Session session;
            block9: {
                boolean existingTransaction = false;
                session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
                if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
                    this.logger.debug((Object)"Found thread-bound session for Hibernate interceptor");
                    existingTransaction = true;
                } else {
                    this.logger.debug((Object)"Using new session for Hibernate interceptor");
                    if (this.getFlushMode() == 0) {
                        session.setFlushMode(FlushMode.NEVER);
                    }
                    TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
                }
                try {
                    Object retVal = methodInvocation.proceed();
                    this.flushIfNecessary(session, existingTransaction);
                    object = retVal;
                    Object var7_7 = null;
                    if (!existingTransaction) break block9;
                }
                catch (HibernateException ex) {
                    try {
                        throw this.convertHibernateAccessException(ex);
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (existingTransaction) {
                            this.logger.debug((Object)"Not closing pre-bound Hibernate session after interceptor");
                        } else {
                            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                            SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
                        }
                        throw throwable;
                    }
                }
                this.logger.debug((Object)"Not closing pre-bound Hibernate session after interceptor");
                break block10;
            }
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
            SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
        }
        return object;
    }
}

