/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private Map beans = new HashMap();

    public Object getBean(String name) throws BeansException {
        Object bean = this.beans.get(name);
        if (bean instanceof FactoryBean) {
            try {
                return ((FactoryBean)bean).getObject();
            }
            catch (Exception ex) {
                throw new BeanCreationException("FactoryBean threw exception on object creation", ex);
            }
        }
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name, "defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        return bean;
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.getBean(name);
        if (!requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean);
        }
        return bean;
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name);
        if (bean instanceof FactoryBean) {
            return ((FactoryBean)bean).isSingleton();
        }
        return true;
    }

    public String[] getAliases(String name) {
        return null;
    }

    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    public String[] getBeanDefinitionNames() {
        return this.beans.keySet().toArray(new String[this.beans.keySet().size()]);
    }

    public String[] getBeanDefinitionNames(Class type) {
        LinkedList<String> matches = new LinkedList<String>();
        Set keys = this.beans.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            Class<?> clazz = this.beans.get(name).getClass();
            if (!type.isAssignableFrom(clazz)) continue;
            matches.add(name);
        }
        return matches.toArray(new String[matches.size()]);
    }

    public boolean containsBeanDefinition(String name) {
        return this.beans.containsKey(name);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        HashMap<String, Object> matches = new HashMap<String, Object>();
        Set keys = this.beans.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            Object bean = this.beans.get(name);
            if (bean instanceof FactoryBean && includeFactoryBeans) {
                Object createdObject;
                FactoryBean factory = (FactoryBean)bean;
                Class objectType = factory.getObjectType();
                if ((objectType != null || !factory.isSingleton()) && (!factory.isSingleton() && !includePrototypes || objectType == null || !type.isAssignableFrom(objectType)) || !type.isInstance(createdObject = this.getBean(name))) continue;
                matches.put(name, createdObject);
                continue;
            }
            if (!type.isAssignableFrom(bean.getClass())) continue;
            matches.put(name, bean);
        }
        return matches;
    }

    public void addBean(String name, Object bean) {
        this.beans.put(name, bean);
    }
}

