/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractNestingMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class ReloadableResourceBundleMessageSource
extends AbstractNestingMessageSource
implements ApplicationContextAware {
    public static final String PROPERTIES_SUFFIX = ".properties";
    private ApplicationContext applicationContext;
    private String[] basenames;
    private boolean fallbackToSystemLocale = true;
    private long cacheMillis = -1L;
    private final Map cachedFilenames = new HashMap();
    private final Map cachedProperties = new HashMap();

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = cacheSeconds * 1000;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    protected MessageFormat resolve(String code, Locale locale) {
        for (int i = 0; i < this.basenames.length; ++i) {
            List filenames = this.calculateAllFilenames(this.basenames[i], locale);
            for (int j = 0; j < filenames.size(); ++j) {
                MessageFormat result;
                String filename = (String)filenames.get(j);
                PropertiesHolder propHolder = this.getProperties(filename);
                if (propHolder.getProperties() == null || (result = propHolder.getMessageFormat(code)) == null) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List calculateAllFilenames(String basename, Locale locale) {
        ArrayList<String> filenames = null;
        Map map = this.cachedFilenames;
        synchronized (map) {
            filenames = (ArrayList<String>)this.cachedFilenames.get(locale);
            if (filenames == null) {
                filenames = new ArrayList<String>(7);
                filenames.addAll(this.calculateFilenamesForLocale(basename, locale));
                if (this.fallbackToSystemLocale && !locale.equals(Locale.getDefault())) {
                    filenames.addAll(this.calculateFilenamesForLocale(basename, Locale.getDefault()));
                }
                filenames.add(basename);
                this.cachedFilenames.put(locale, filenames);
            }
        }
        return filenames;
    }

    protected List calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer temp = new StringBuffer(basename);
        if (language.length() > 0) {
            temp.append('_').append(language);
            result.add(0, temp.toString());
        }
        if (country.length() > 0) {
            temp.append('_').append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getProperties(String filename) {
        Map map = this.cachedProperties;
        synchronized (map) {
            PropertiesHolder propHolder = (PropertiesHolder)this.cachedProperties.get(filename);
            if (propHolder != null && (propHolder.getRefreshTimestamp() < 0L || propHolder.getRefreshTimestamp() > System.currentTimeMillis() - this.cacheMillis)) {
                return propHolder;
            }
            return this.refreshProperties(filename, propHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder refreshProperties(String filename, PropertiesHolder propHolder) {
        long refreshTimestamp = this.cacheMillis < 0L ? -1L : System.currentTimeMillis();
        Resource resource = this.applicationContext.getResource(filename + PROPERTIES_SUFFIX);
        try {
            long fileTimestamp = -1L;
            if (this.cacheMillis >= 0L) {
                fileTimestamp = resource.getFile().lastModified();
                if (fileTimestamp == 0L) {
                    throw new IOException("File [" + resource.getFile().getAbsolutePath() + "] does not exist");
                }
                if (propHolder != null && propHolder.getFileTimestamp() == fileTimestamp) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Re-caching properties for filename [" + filename + "] - file hasn't been modified"));
                    }
                    propHolder.setRefreshTimestamp(refreshTimestamp);
                    return propHolder;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading properties for filename [" + filename + "]"));
            }
            InputStream is = resource.getInputStream();
            Properties props = new Properties();
            try {
                props.load(is);
                propHolder = new PropertiesHolder(props, fileTimestamp);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Properties file [" + filename + "] not found for MessageSource: " + ex.getMessage()));
            }
            propHolder = new PropertiesHolder();
        }
        propHolder.setRefreshTimestamp(refreshTimestamp);
        this.cachedProperties.put(filename, propHolder);
        return propHolder;
    }

    public synchronized void clearCache() {
        this.cachedProperties.clear();
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }

    protected static class PropertiesHolder {
        private Properties properties;
        private long fileTimestamp = -1L;
        private long refreshTimestamp = -1L;
        private final Map cachedMessageFormats = new HashMap();

        public PropertiesHolder(Properties properties, long fileTimestamp) {
            this.properties = properties;
            this.fileTimestamp = fileTimestamp;
        }

        public PropertiesHolder() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public long getFileTimestamp() {
            return this.fileTimestamp;
        }

        public void setRefreshTimestamp(long refreshTimestamp) {
            this.refreshTimestamp = refreshTimestamp;
        }

        public long getRefreshTimestamp() {
            return this.refreshTimestamp;
        }

        public synchronized MessageFormat getMessageFormat(String code) {
            MessageFormat result = (MessageFormat)this.cachedMessageFormats.get(code);
            if (result != null) {
                return result;
            }
            String msg = this.properties.getProperty(code);
            if (msg != null) {
                result = new MessageFormat(msg);
                this.cachedMessageFormats.put(code, result);
            }
            return result;
        }
    }
}

