/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DefaultXmlBeanDefinitionParser
implements XmlBeanDefinitionParser {
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String TRUE_VALUE = "true";
    public static final String DEFAULT_VALUE = "default";
    public static final String DEFAULT_LAZY_INIT_ATTRIBUTE = "default-lazy-init";
    public static final String DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE = "default-dependency-check";
    public static final String DEFAULT_AUTOWIRE_ATTRIBUTE = "default-autowire";
    public static final String BEAN_ELEMENT = "bean";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String PARENT_ATTRIBUTE = "parent";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String SINGLETON_ATTRIBUTE = "singleton";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String INIT_METHOD_ATTRIBUTE = "init-method";
    public static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    public static final String CONSTRUCTOR_ARG_ELEMENT = "constructor-arg";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String REF_ELEMENT = "ref";
    public static final String IDREF_ELEMENT = "idref";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String BEAN_REF_ATTRIBUTE = "bean";
    public static final String LOCAL_REF_ATTRIBUTE = "local";
    public static final String VALUE_ELEMENT = "value";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    public static final String LAZY_INIT_ATTRIBUTE = "lazy-init";
    public static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    public static final String DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE = "all";
    public static final String DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE = "simple";
    public static final String DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE = "objects";
    public static final String AUTOWIRE_ATTRIBUTE = "autowire";
    public static final String AUTOWIRE_BY_NAME_VALUE = "byName";
    public static final String AUTOWIRE_BY_TYPE_VALUE = "byType";
    public static final String AUTOWIRE_CONSTRUCTOR_VALUE = "constructor";
    public static final String AUTOWIRE_AUTODETECT_VALUE = "autodetect";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanDefinitionRegistry beanFactory;
    private ClassLoader beanClassLoader;
    private Resource resource;
    private String defaultLazyInit;
    private String defaultDependencyCheck;
    private String defaultAutowire;

    public void registerBeanDefinitions(BeanDefinitionRegistry beanFactory, ClassLoader beanClassLoader, Document doc, Resource resource) {
        this.beanFactory = beanFactory;
        this.beanClassLoader = beanClassLoader;
        this.resource = resource;
        this.logger.debug((Object)"Loading bean definitions");
        Element root = doc.getDocumentElement();
        this.defaultLazyInit = root.getAttribute(DEFAULT_LAZY_INIT_ATTRIBUTE);
        this.logger.debug((Object)("Default lazy init '" + this.defaultLazyInit + "'"));
        this.defaultDependencyCheck = root.getAttribute(DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE);
        this.logger.debug((Object)("Default dependency check '" + this.defaultDependencyCheck + "'"));
        this.defaultAutowire = root.getAttribute(DEFAULT_AUTOWIRE_ATTRIBUTE);
        this.logger.debug((Object)("Default autowire '" + this.defaultAutowire + "'"));
        NodeList nl = root.getChildNodes();
        int beanDefinitionCounter = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !"bean".equals(node.getNodeName())) continue;
            ++beanDefinitionCounter;
            this.loadBeanDefinition((Element)node);
        }
        this.logger.debug((Object)("Found " + beanDefinitionCounter + " <" + "bean" + "> elements defining beans"));
    }

    protected BeanDefinitionRegistry getBeanFactory() {
        return this.beanFactory;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    protected String getDefaultLazyInit() {
        return this.defaultLazyInit;
    }

    protected String getDefaultDependencyCheck() {
        return this.defaultDependencyCheck;
    }

    protected String getDefaultAutowire() {
        return this.defaultAutowire;
    }

    protected void loadBeanDefinition(Element ele) {
        String id = ele.getAttribute(ID_ATTRIBUTE);
        String nameAttr = ele.getAttribute(NAME_ATTRIBUTE);
        ArrayList<String> aliases = new ArrayList<String>();
        if (nameAttr != null && !"".equals(nameAttr)) {
            aliases.addAll(Arrays.asList(StringUtils.tokenizeToStringArray(nameAttr, BEAN_NAME_DELIMITERS, true, true)));
        }
        if (id == null || "".equals(id) && !aliases.isEmpty()) {
            id = (String)aliases.remove(0);
            this.logger.debug((Object)("No XML 'id' specified - using '" + id + "' as ID and " + aliases + " as aliases"));
        }
        AbstractBeanDefinition beanDefinition = this.parseBeanDefinition(ele, id);
        if (id == null || "".equals(id)) {
            if (beanDefinition instanceof RootBeanDefinition) {
                id = ((RootBeanDefinition)beanDefinition).getBeanClassName();
                this.logger.debug((Object)("Neither XML 'id' nor 'name' specified - using bean class name [" + id + "] as ID"));
            } else {
                throw new BeanDefinitionStoreException(this.resource, "", "Child bean definition has neither 'id' nor 'name'");
            }
        }
        this.logger.debug((Object)("Registering bean definition with id '" + id + "'"));
        this.beanFactory.registerBeanDefinition(id, beanDefinition);
        Iterator it = aliases.iterator();
        while (it.hasNext()) {
            this.beanFactory.registerAlias(id, (String)it.next());
        }
    }

    protected AbstractBeanDefinition parseBeanDefinition(Element ele, String beanName) {
        String className = null;
        try {
            String lazyInit;
            if (ele.hasAttribute(CLASS_ATTRIBUTE)) {
                className = ele.getAttribute(CLASS_ATTRIBUTE);
            }
            String parent = null;
            if (ele.hasAttribute(PARENT_ATTRIBUTE)) {
                parent = ele.getAttribute(PARENT_ATTRIBUTE);
            }
            if (className == null && parent == null) {
                throw new BeanDefinitionStoreException(this.resource, beanName, "Either 'class' or 'parent' is required");
            }
            AbstractBeanDefinition bd = null;
            MutablePropertyValues pvs = this.getPropertyValueSubElements(beanName, ele);
            if (className != null) {
                String destroyMethodName;
                String dependencyCheck;
                ConstructorArgumentValues cargs = this.getConstructorArgSubElements(beanName, ele);
                RootBeanDefinition rbd = null;
                if (this.beanClassLoader != null) {
                    Class<?> clazz = Class.forName(className, true, this.beanClassLoader);
                    rbd = new RootBeanDefinition(clazz, cargs, pvs);
                } else {
                    rbd = new RootBeanDefinition(className, cargs, pvs);
                }
                if (ele.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
                    String dependsOn = ele.getAttribute(DEPENDS_ON_ATTRIBUTE);
                    rbd.setDependsOn(StringUtils.tokenizeToStringArray(dependsOn, BEAN_NAME_DELIMITERS, true, true));
                }
                if (DEFAULT_VALUE.equals(dependencyCheck = ele.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE))) {
                    dependencyCheck = this.defaultDependencyCheck;
                }
                rbd.setDependencyCheck(this.getDependencyCheck(dependencyCheck));
                String autowire = ele.getAttribute(AUTOWIRE_ATTRIBUTE);
                if (DEFAULT_VALUE.equals(autowire)) {
                    autowire = this.defaultAutowire;
                }
                rbd.setAutowireMode(this.getAutowireMode(autowire));
                String initMethodName = ele.getAttribute(INIT_METHOD_ATTRIBUTE);
                if (!initMethodName.equals("")) {
                    rbd.setInitMethodName(initMethodName);
                }
                if (!(destroyMethodName = ele.getAttribute(DESTROY_METHOD_ATTRIBUTE)).equals("")) {
                    rbd.setDestroyMethodName(destroyMethodName);
                }
                bd = rbd;
            } else {
                bd = new ChildBeanDefinition(parent, pvs);
            }
            if (ele.hasAttribute(SINGLETON_ATTRIBUTE)) {
                bd.setSingleton(TRUE_VALUE.equals(ele.getAttribute(SINGLETON_ATTRIBUTE)));
            }
            if (DEFAULT_VALUE.equals(lazyInit = ele.getAttribute(LAZY_INIT_ATTRIBUTE)) && bd.isSingleton()) {
                lazyInit = this.defaultLazyInit;
            }
            bd.setLazyInit(TRUE_VALUE.equals(lazyInit));
            bd.setResourceDescription(this.resource.getDescription());
            return bd;
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException(this.resource, beanName, "Class [" + className + "] not found", (Throwable)ex);
        }
    }

    protected ConstructorArgumentValues getConstructorArgSubElements(String beanName, Element beanEle) {
        NodeList nl = beanEle.getChildNodes();
        ConstructorArgumentValues cargs = new ConstructorArgumentValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !CONSTRUCTOR_ARG_ELEMENT.equals(node.getNodeName())) continue;
            this.parseConstructorArgElement(beanName, cargs, (Element)node);
        }
        return cargs;
    }

    protected MutablePropertyValues getPropertyValueSubElements(String beanName, Element beanEle) {
        NodeList nl = beanEle.getChildNodes();
        MutablePropertyValues pvs = new MutablePropertyValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !PROPERTY_ELEMENT.equals(node.getNodeName())) continue;
            this.parsePropertyElement(beanName, pvs, (Element)node);
        }
        return pvs;
    }

    protected void parseConstructorArgElement(String beanName, ConstructorArgumentValues cargs, Element ele) throws DOMException {
        Object val = this.getPropertyValue(ele, beanName);
        String indexAttr = ele.getAttribute(INDEX_ATTRIBUTE);
        if (!"".equals(indexAttr)) {
            try {
                int index = Integer.parseInt(indexAttr);
                if (index < 0) {
                    throw new BeanDefinitionStoreException(this.resource, beanName, "'index' cannot be lower than 0");
                }
                cargs.addIndexedArgumentValue(index, val);
            }
            catch (NumberFormatException ex) {
                throw new BeanDefinitionStoreException(this.resource, beanName, "Attribute 'index' of tag 'constructor-arg' must be an integer");
            }
        } else {
            cargs.addGenericArgumentValue(val);
        }
    }

    protected void parsePropertyElement(String beanName, MutablePropertyValues pvs, Element ele) throws DOMException {
        String propertyName = ele.getAttribute(NAME_ATTRIBUTE);
        if ("".equals(propertyName)) {
            throw new BeanDefinitionStoreException(this.resource, beanName, "Tag 'property' must have a 'name' attribute");
        }
        Object val = this.getPropertyValue(ele, beanName);
        pvs.addPropertyValue(new PropertyValue(propertyName, val));
    }

    protected Object getPropertyValue(Element ele, String beanName) {
        NodeList nl = ele.getChildNodes();
        Element valueRefOrCollectionElement = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element candidateEle;
            if (!(nl.item(i) instanceof Element) || DESCRIPTION_ELEMENT.equals((candidateEle = (Element)nl.item(i)).getTagName())) continue;
            valueRefOrCollectionElement = candidateEle;
        }
        if (valueRefOrCollectionElement == null) {
            throw new BeanDefinitionStoreException("<property> element must have a value, ref, or collection subelement");
        }
        return this.parsePropertySubelement(valueRefOrCollectionElement, beanName);
    }

    protected Object parsePropertySubelement(Element ele, String beanName) {
        if (ele.getTagName().equals("bean")) {
            return this.parseBeanDefinition(ele, "(inner bean definition)");
        }
        if (ele.getTagName().equals(REF_ELEMENT)) {
            String beanRef = ele.getAttribute("bean");
            if ("".equals(beanRef) && "".equals(beanRef = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                throw new BeanDefinitionStoreException(this.resource, beanName, "Either 'bean' or 'local' is required for a reference");
            }
            return new RuntimeBeanReference(beanRef);
        }
        if (ele.getTagName().equals(IDREF_ELEMENT)) {
            String beanRef = ele.getAttribute("bean");
            if ("".equals(beanRef) && "".equals(beanRef = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                throw new BeanDefinitionStoreException(this.resource, beanName, "Either 'bean' or 'local' is required for an idref");
            }
            return beanRef;
        }
        if (ele.getTagName().equals(VALUE_ELEMENT)) {
            return this.getTextValue(ele, beanName);
        }
        if (ele.getTagName().equals(LIST_ELEMENT)) {
            return this.getList(ele, beanName);
        }
        if (ele.getTagName().equals(SET_ELEMENT)) {
            return this.getSet(ele, beanName);
        }
        if (ele.getTagName().equals(MAP_ELEMENT)) {
            return this.getMap(ele, beanName);
        }
        if (ele.getTagName().equals(PROPS_ELEMENT)) {
            return this.getProps(ele, beanName);
        }
        throw new BeanDefinitionStoreException(this.resource, beanName, "Unknown subelement of <property>: <" + ele.getTagName() + ">");
    }

    protected List getList(Element collectionEle, String beanName) {
        NodeList nl = collectionEle.getChildNodes();
        ManagedList l = new ManagedList();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            l.add(this.parsePropertySubelement(ele, beanName));
        }
        return l;
    }

    protected Set getSet(Element collectionEle, String beanName) {
        NodeList nl = collectionEle.getChildNodes();
        ManagedSet s = new ManagedSet();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            s.add(this.parsePropertySubelement(ele, beanName));
        }
        return s;
    }

    protected Map getMap(Element mapEle, String beanName) {
        ManagedMap m = new ManagedMap();
        List l = this.getChildElementsByTagName(mapEle, ENTRY_ELEMENT);
        for (int i = 0; i < l.size(); ++i) {
            Element entryEle = (Element)l.get(i);
            String key = entryEle.getAttribute(KEY_ATTRIBUTE);
            NodeList subEles = entryEle.getElementsByTagName("*");
            m.put(key, this.parsePropertySubelement((Element)subEles.item(0), beanName));
        }
        return m;
    }

    protected List getChildElementsByTagName(Element mapEle, String elementName) {
        NodeList nl = mapEle.getChildNodes();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || !elementName.equals(n.getNodeName())) continue;
            nodes.add(n);
        }
        return nodes;
    }

    protected Properties getProps(Element propsEle, String beanName) {
        Properties p = new Properties();
        NodeList nl = propsEle.getElementsByTagName(PROP_ELEMENT);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element propEle = (Element)nl.item(i);
            String key = propEle.getAttribute(KEY_ATTRIBUTE);
            String value = this.getTextValue(propEle, beanName);
            p.setProperty(key, value);
        }
        return p;
    }

    protected String getTextValue(Element ele, String beanName) {
        NodeList nl = ele.getChildNodes();
        if (nl.item(0) == null) {
            return "";
        }
        if (nl.getLength() != 1 || !(nl.item(0) instanceof Text)) {
            throw new BeanDefinitionStoreException(this.resource, beanName, "Unexpected element or type mismatch: expected single node of " + nl.item(0).getClass() + " to be of type Text: " + "found " + ele, null);
        }
        Text t = (Text)nl.item(0);
        return t.getData();
    }

    protected int getDependencyCheck(String att) {
        int dependencyCheckCode = 0;
        if (DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 3;
        } else if (DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 2;
        } else if (DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 1;
        }
        return dependencyCheckCode;
    }

    protected int getAutowireMode(String att) {
        int autowire = 0;
        if (AUTOWIRE_BY_NAME_VALUE.equals(att)) {
            autowire = 1;
        } else if (AUTOWIRE_BY_TYPE_VALUE.equals(att)) {
            autowire = 2;
        } else if (AUTOWIRE_CONSTRUCTOR_VALUE.equals(att)) {
            autowire = 3;
        } else if (AUTOWIRE_AUTODETECT_VALUE.equals(att)) {
            autowire = 4;
        }
        return autowire;
    }
}

