/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConstructorArgumentValues {
    private Map indexedArgumentValues = new HashMap();
    private Set genericArgumentValues = new HashSet();

    public void addIndexedArgumentValue(int index, Object value) {
        this.indexedArgumentValues.put(new Integer(index), value);
    }

    public Object getIndexedArgumentValue(int index) {
        return this.indexedArgumentValues.get(new Integer(index));
    }

    public Map getIndexedArgumentValues() {
        return this.indexedArgumentValues;
    }

    public void addGenericArgumentValue(Object value) {
        this.genericArgumentValues.add(value);
    }

    public Object getGenericArgumentValue(Class requiredType) {
        Iterator it = this.genericArgumentValues.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (!requiredType.isInstance(value) && (!requiredType.isArray() || !(value instanceof List))) continue;
            return value;
        }
        return null;
    }

    public Set getGenericArgumentValues() {
        return this.genericArgumentValues;
    }

    public Object getArgumentValue(int index, Class requiredType) {
        Object value = this.getIndexedArgumentValue(index);
        if (value == null) {
            value = this.getGenericArgumentValue(requiredType);
        }
        return value;
    }

    public int getNrOfArguments() {
        return this.indexedArgumentValues.size() + this.genericArgumentValues.size();
    }

    public boolean isEmpty() {
        return this.indexedArgumentValues.isEmpty() && this.genericArgumentValues.isEmpty();
    }
}

