/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles;

import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactory;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.view.InternalResourceView;

public class TilesView
extends InternalResourceView {
    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestDispatcher rd;
        ComponentDefinition definition;
        DefinitionsFactory factory;
        if (!response.isCommitted()) {
            response.setContentType(this.getContentType());
        }
        if ((factory = (DefinitionsFactory)this.getWebApplicationContext().getServletContext().getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY")) == null) {
            response.sendError(500, "Tiles definitions factory not found: TilesConfigurer not defined?");
        }
        if ((definition = factory.getDefinition(this.getUrl(), (ServletRequest)request, this.getServletContext())) == null) {
            response.sendError(404, "Tile with name '" + this.getName() + "' not found");
            return;
        }
        this.exposeModelAsRequestAttributes(model, request);
        ComponentContext tileContext = ComponentContext.getContext((ServletRequest)request);
        if (tileContext == null) {
            tileContext = new ComponentContext(definition.getAttributes());
            ComponentContext.setContext((ComponentContext)tileContext, (ServletRequest)request);
        } else {
            tileContext.addMissing(definition.getAttributes());
        }
        Controller controller = definition.getOrCreateController();
        if (controller instanceof ApplicationContextAware) {
            ((ApplicationContextAware)controller).setApplicationContext(this.getApplicationContext());
        }
        if (controller != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing controller [" + controller + "]"));
            }
            controller.perform(tileContext, request, response, this.getServletContext());
        }
        if ((rd = request.getRequestDispatcher(definition.getPath())) == null) {
            response.sendError(500);
            return;
        }
        rd.include((ServletRequest)request, (ServletResponse)response);
    }
}

