/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;

public abstract class AbstractView
extends WebApplicationObjectSupport
implements View {
    private Map staticAttributes = new HashMap();
    private String requestContextAttribute;
    private String contentType = "text/html; charset=ISO-8859-1";
    private String name;

    public final void setAttributes(Properties props) {
        this.setAttributesMap(props);
    }

    public final void setAttributesMap(Map attributes) {
        if (attributes != null) {
            Iterator itr = attributes.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Object value = attributes.get(name);
                this.addStaticAttribute(name, value);
            }
        }
    }

    public final void setAttributesCSV(String propString) throws IllegalArgumentException {
        if (propString == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(propString, ",");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            int eqindx = tok.indexOf("=");
            if (eqindx == -1) {
                throw new IllegalArgumentException("Expected = in View string '" + propString + "'");
            }
            if (eqindx >= tok.length() - 2) {
                throw new IllegalArgumentException("At least 2 characters ([]) required in View string '" + propString + "'");
            }
            String name = tok.substring(0, eqindx);
            String val = tok.substring(eqindx + 1);
            val = val.substring(1);
            val = val.substring(0, val.length() - 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.info((Object)("Set static attribute with name '" + name + "' and value [" + val + "] on view"));
            }
            this.addStaticAttribute(name, val);
        }
    }

    public final void addStaticAttribute(String name, Object value) {
        this.logger.debug((Object)("Set static attribute with name '" + name + "' and value [" + value + "] on view"));
        this.staticAttributes.put(name, value);
    }

    public final Map getStaticAttributes() {
        return Collections.unmodifiableMap(this.staticAttributes);
    }

    public final void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public final void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected final String getContentType() {
        return this.contentType;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view with name '" + this.name + "' with model=[" + model + "] and static attributes=[" + this.staticAttributes + "]"));
        }
        HashMap<String, RequestContext> mergedModel = new HashMap<String, RequestContext>(this.staticAttributes);
        mergedModel.putAll(model);
        if (this.requestContextAttribute != null) {
            mergedModel.put(this.requestContextAttribute, new RequestContext(request, mergedModel));
        }
        this.renderMergedOutputModel(mergedModel, request, response);
    }

    protected abstract void renderMergedOutputModel(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;
}

