/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.servlet.tags.RequestContextAwareTag;
import org.springframework.web.servlet.tags.TagUtils;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;

public class MessageTag
extends RequestContextAwareTag {
    private String code = null;
    private String text = null;
    private String var = null;
    private int scope = 1;

    public final void setCode(String code) throws JspException {
        this.code = ExpressionEvaluationUtils.evaluateString("code", code, this.pageContext);
    }

    public final void setText(String text) throws JspException {
        this.text = ExpressionEvaluationUtils.evaluateString("text", text, this.pageContext);
    }

    public final void setVar(String var) throws JspException {
        this.var = ExpressionEvaluationUtils.evaluateString("var", var, this.pageContext);
    }

    public final void setScope(String scope) throws JspException {
        String tmpScope = ExpressionEvaluationUtils.evaluateString("scope", this.var, this.pageContext);
        this.scope = TagUtils.getScope(tmpScope);
    }

    protected final int doStartTagInternal() throws Exception {
        MessageSource messageSource = this.getMessageSource();
        if (messageSource == null) {
            throw new JspTagException("No corresponding MessageSource found");
        }
        try {
            String msg = null;
            msg = this.code != null ? (this.text != null ? messageSource.getMessage(this.code, null, this.text, this.getRequestContext().getLocale()) : messageSource.getMessage(this.code, null, this.getRequestContext().getLocale())) : this.text;
            String string = msg = this.isHtmlEscape() ? HtmlUtils.htmlEscape(msg) : msg;
            if (this.var == null) {
                this.writeMessage(msg);
            } else {
                this.pageContext.setAttribute(this.var, (Object)msg, this.scope);
            }
        }
        catch (NoSuchMessageException ex) {
            throw new JspTagException(this.getNoSuchMessageExceptionDescription(ex));
        }
        return 1;
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write(msg);
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getWebApplicationContext();
    }

    protected String getNoSuchMessageExceptionDescription(NoSuchMessageException ex) {
        return ex.getMessage();
    }

    public void release() {
        super.release();
        this.var = null;
        this.scope = 1;
        this.code = null;
        this.text = null;
    }
}

