/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler.metadata;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.config.ConfigurableApplicationContext;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.handler.metadata.PathMap;

public abstract class AbstractPathMapHandlerMapping
extends AbstractUrlHandlerMapping {
    public void initApplicationContext() throws ApplicationContextException {
        try {
            this.logger.info((Object)("Looking for attribute-defined URL mappings in application context: " + this.getApplicationContext()));
            Collection names = this.getClassNamesWithPathMapAttributes();
            this.logger.info((Object)("Found " + names.size() + " attribute-targeted handlers"));
            Iterator itr = names.iterator();
            while (itr.hasNext()) {
                String handlerClassName = (String)itr.next();
                Class<?> handlerClass = Class.forName(handlerClassName);
                Object handler = this.getApplicationContext().autowire(handlerClass);
                if (this.getApplicationContext() instanceof ConfigurableApplicationContext) {
                    ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.getApplicationContext()).getBeanFactory();
                    beanFactory.registerSingleton(handlerClassName, handler);
                }
                PathMap[] pathMaps = this.getPathMapAttributes(handlerClass);
                for (int i = 0; i < pathMaps.length; ++i) {
                    PathMap pathMap = pathMaps[i];
                    String path = pathMap.getUrl();
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    this.logger.info((Object)("Mapping path [" + path + "] to class with name '" + handlerClassName + "'"));
                    this.registerHandler(path, handler);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ApplicationContextException("Failed to load a class returned in an attribute index: internal error in Commons Attributes indexing?", ex);
        }
    }

    protected abstract Collection getClassNamesWithPathMapAttributes();

    protected abstract PathMap[] getPathMapAttributes(Class var1);
}

