/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.cos;

import com.oreilly.servlet.MultipartRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class CosMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private MultipartRequest multipartRequest;

    protected CosMultipartHttpServletRequest(HttpServletRequest originalRequest, MultipartRequest multipartRequest) {
        super(originalRequest);
        this.multipartRequest = multipartRequest;
        this.setMultipartFiles(this.initFileMap(multipartRequest));
    }

    public MultipartRequest getMultipartRequest() {
        return this.multipartRequest;
    }

    protected Map initFileMap(MultipartRequest multipartRequest) {
        HashMap<String, CosMultipartFile> files = new HashMap<String, CosMultipartFile>();
        Enumeration fileNames = multipartRequest.getFileNames();
        while (fileNames.hasMoreElements()) {
            String fileName = (String)fileNames.nextElement();
            files.put(fileName, new CosMultipartFile(fileName));
        }
        return files;
    }

    public Enumeration getParameterNames() {
        return this.multipartRequest.getParameterNames();
    }

    public String getParameter(String name) {
        return this.multipartRequest.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.multipartRequest.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        Enumeration names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            params.put(name, this.getParameterValues(name));
        }
        return Collections.unmodifiableMap(params);
    }

    private class CosMultipartFile
    implements MultipartFile {
        private String name;

        private CosMultipartFile(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEmpty() {
            return CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name) == null;
        }

        public String getOriginalFileName() {
            return CosMultipartHttpServletRequest.this.multipartRequest.getOriginalFileName(this.name);
        }

        public String getContentType() {
            return CosMultipartHttpServletRequest.this.multipartRequest.getContentType(this.name);
        }

        public long getSize() {
            File file = CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name);
            return file != null ? file.length() : 0L;
        }

        public byte[] getBytes() throws IOException {
            File file = CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name);
            return file != null ? FileCopyUtils.copyToByteArray(file) : new byte[]{};
        }

        public InputStream getInputStream() throws IOException {
            File file = CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name);
            return file != null ? new FileInputStream(file) : new ByteArrayInputStream(new byte[0]);
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            File tempFile = CosMultipartHttpServletRequest.this.multipartRequest.getFile(this.name);
            if (tempFile != null) {
                if (!tempFile.exists()) {
                    throw new IllegalStateException("File has already been moved - cannot be transferred again");
                }
                if (dest.exists() && !dest.delete()) {
                    throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
                }
                if (tempFile.renameTo(dest)) {
                    if (CosMultipartHttpServletRequest.this.logger.isDebugEnabled()) {
                        CosMultipartHttpServletRequest.this.logger.debug((Object)("Multipart file [" + this.getName() + "] with original file name [" + this.getOriginalFileName() + "], stored at [" + tempFile.getAbsolutePath() + "]: moved to [" + dest.getAbsolutePath() + "]"));
                    }
                } else {
                    FileCopyUtils.copy(tempFile, dest);
                    if (CosMultipartHttpServletRequest.this.logger.isDebugEnabled()) {
                        CosMultipartHttpServletRequest.this.logger.debug((Object)("Multipart file [" + this.getName() + "] with original file name [" + this.getOriginalFileName() + "], stored at [" + tempFile.getAbsolutePath() + "]: copied to [" + dest.getAbsolutePath() + "]"));
                    }
                }
            } else {
                dest.createNewFile();
            }
        }
    }
}

