/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jdo.JdoTemplate;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;

public abstract class JdoDaoSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JdoTemplate jdoTemplate;

    public final void setPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
        this.jdoTemplate = new JdoTemplate(persistenceManagerFactory);
    }

    protected final PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoTemplate.getPersistenceManagerFactory();
    }

    public final void setJdoTemplate(JdoTemplate jdoTemplate) {
        this.jdoTemplate = jdoTemplate;
    }

    protected final JdoTemplate getJdoTemplate() {
        return this.jdoTemplate;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.jdoTemplate == null) {
            throw new IllegalArgumentException("persistenceManagerFactory or jdoTemplate is required");
        }
        this.initDao();
    }

    protected void initDao() throws Exception {
    }

    protected final PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(this.getJdoTemplate().isAllowCreate());
    }

    protected final PersistenceManager getPersistenceManager(boolean allowCreate) throws DataAccessResourceFailureException {
        return PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), allowCreate);
    }

    protected final void closeSessionIfNecessary(PersistenceManager pm) throws CleanupFailureDataAccessException {
        PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
    }
}

