/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jdo.JdoSystemException;
import org.springframework.orm.jdo.JdoUsageException;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class PersistenceManagerFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils == null ? (class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils = PersistenceManagerFactoryUtils.class$("org.springframework.orm.jdo.PersistenceManagerFactoryUtils")) : class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils));
    static /* synthetic */ Class class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils;

    public static PersistenceManager getPersistenceManager(PersistenceManagerFactory pmf, boolean allowCreate) throws DataAccessResourceFailureException {
        PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.getResource(pmf);
        if (pmHolder != null) {
            return pmHolder.getPersistenceManager();
        }
        if (!allowCreate) {
            throw new IllegalStateException("Not allowed to create new persistence manager");
        }
        logger.debug((Object)"Opening JDO persistence manager");
        try {
            PersistenceManager pm = pmf.getPersistenceManager();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                logger.debug((Object)"Registering transaction synchronization for JDO persistence manager");
                TransactionSynchronizationManager.bindResource(pmf, new PersistenceManagerHolder(pm));
                TransactionSynchronizationManager.registerSynchronization(new PersistenceManagerSynchronization(pm, pmf));
            }
            return pm;
        }
        catch (JDOException ex) {
            throw new DataAccessResourceFailureException("Cannot get JDO persistence manager", ex);
        }
    }

    public static DataAccessException convertJdoAccessException(JDOException ex) {
        if (ex instanceof JDOUserException || ex instanceof JDOFatalUserException) {
            return new JdoUsageException(ex);
        }
        return new JdoSystemException(ex);
    }

    public static void closePersistenceManagerIfNecessary(PersistenceManager pm, PersistenceManagerFactory pmf) throws CleanupFailureDataAccessException {
        if (pm == null || TransactionSynchronizationManager.hasResource(pmf)) {
            return;
        }
        logger.debug((Object)"Closing JDO persistence manager");
        try {
            pm.close();
        }
        catch (JDOException ex) {
            throw new CleanupFailureDataAccessException("Cannot close JDO persistence manager", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PersistenceManagerSynchronization
    implements TransactionSynchronization {
        private PersistenceManager persistenceManager;
        private PersistenceManagerFactory persistenceManagerFactory;

        public PersistenceManagerSynchronization(PersistenceManager pm, PersistenceManagerFactory pmf) {
            this.persistenceManager = pm;
            this.persistenceManagerFactory = pmf;
        }

        public void beforeCommit() {
        }

        public void beforeCompletion() throws CleanupFailureDataAccessException {
            TransactionSynchronizationManager.unbindResource(this.persistenceManagerFactory);
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(this.persistenceManager, this.persistenceManagerFactory);
        }

        public void afterCompletion(int status) {
        }
    }
}

