/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import javax.sql.DataSource;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.object.SqlOperation;

public class SqlUpdate
extends SqlOperation {
    private int maxRowsAffected;
    private int requiredRowsAffected;

    public SqlUpdate() {
    }

    public SqlUpdate(DataSource ds, String sql) {
        this(ds, sql, null, Integer.MAX_VALUE);
    }

    public SqlUpdate(DataSource ds, String sql, int[] types) {
        this(ds, sql, types, Integer.MAX_VALUE);
    }

    public SqlUpdate(DataSource ds, String sql, int[] types, int maxRowsAffected) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.maxRowsAffected = maxRowsAffected;
    }

    public void setMaxRowsAffected(int max) {
        this.maxRowsAffected = max;
    }

    public void setRequiredRowsAffected(int rowsAffected) {
        this.requiredRowsAffected = rowsAffected;
    }

    public int update(Object[] args) throws InvalidDataAccessApiUsageException {
        this.validateParameters(args);
        int rowsAffected = this.getJdbcTemplate().update(this.newPreparedStatementCreator(args));
        this.logger.debug((Object)("Executing update statement: " + this.getSql()));
        if (this.maxRowsAffected != 0 && rowsAffected > this.maxRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.maxRowsAffected, rowsAffected);
        }
        if (this.requiredRowsAffected != 0 && rowsAffected != this.requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.requiredRowsAffected, rowsAffected);
        }
        this.logger.debug((Object)(rowsAffected + " rows affected by SQL update [" + this.getSql() + "]"));
        return rowsAffected;
    }

    public int update() {
        return this.update((Object[])null);
    }

    public int update(int p1) {
        return this.update(new Object[]{new Integer(p1)});
    }

    public int update(int p1, int p2) {
        return this.update(new Object[]{new Integer(p1), new Integer(p2)});
    }

    public int update(String p) {
        return this.update(new Object[]{p});
    }

    public int update(String p1, String p2) {
        return this.update(new Object[]{p1, p2});
    }
}

