/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.frame;

import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.socket.sockjs.frame.AbstractSockJsMessageCodec;
import tools.jackson.core.io.JsonStringEncoder;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonSockJsMessageCodec
extends AbstractSockJsMessageCodec {
    private final JsonMapper jsonMapper;

    public JacksonJsonSockJsMessageCodec() {
        this.jsonMapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules(JacksonJsonSockJsMessageCodec.class.getClassLoader())).build();
    }

    public JacksonJsonSockJsMessageCodec(JsonMapper jsonMapper) {
        Assert.notNull((Object)jsonMapper, (String)"JsonMapper must not be null");
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String @Nullable [] decode(String content) {
        return (String[])this.jsonMapper.readValue(content, String[].class);
    }

    @Override
    public String @Nullable [] decodeInputStream(InputStream content) {
        return (String[])this.jsonMapper.readValue(content, String[].class);
    }

    @Override
    protected char[] applyJsonQuoting(String content) {
        return JsonStringEncoder.getInstance().quoteAsCharArray((CharSequence)content);
    }
}

