/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.BeanCreatingHandlerProvider;

public class PerConnectionWebSocketHandler
implements WebSocketHandler,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(PerConnectionWebSocketHandler.class);
    private final BeanCreatingHandlerProvider<WebSocketHandler> provider;
    private final Map<WebSocketSession, WebSocketHandler> handlers = new ConcurrentHashMap<WebSocketSession, WebSocketHandler>();
    private final boolean supportsPartialMessages;

    public PerConnectionWebSocketHandler(Class<? extends WebSocketHandler> handlerType) {
        this(handlerType, false);
    }

    public PerConnectionWebSocketHandler(Class<? extends WebSocketHandler> handlerType, boolean supportsPartialMessages) {
        this.provider = new BeanCreatingHandlerProvider<WebSocketHandler>(handlerType);
        this.supportsPartialMessages = supportsPartialMessages;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.provider.setBeanFactory(beanFactory);
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        WebSocketHandler handler = this.provider.getHandler();
        this.handlers.put(session, handler);
        handler.afterConnectionEstablished(session);
    }

    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        this.getHandler(session).handleMessage(session, message);
    }

    private WebSocketHandler getHandler(WebSocketSession session) {
        WebSocketHandler handler = this.handlers.get(session);
        Assert.isTrue((handler != null ? 1 : 0) != 0, (String)("WebSocketHandler not found for " + session));
        return handler;
    }

    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        this.getHandler(session).handleTransportError(session, exception);
    }

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        try {
            this.getHandler(session).afterConnectionClosed(session, closeStatus);
        }
        finally {
            this.destroy(session);
        }
    }

    private void destroy(WebSocketSession session) {
        WebSocketHandler handler = this.handlers.remove(session);
        try {
            if (handler != null) {
                this.provider.destroy(handler);
            }
        }
        catch (Throwable t) {
            logger.warn((Object)("Error while destroying " + handler), t);
        }
    }

    @Override
    public boolean supportsPartialMessages() {
        return this.supportsPartialMessages;
    }

    public String toString() {
        return "PerConnectionWebSocketHandlerProxy[handlerType=" + this.provider.getHandlerType() + "]";
    }
}

