/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.server.DelegatingServerHttpResponse;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.ReactiveTypeHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.view.FragmentsRendering;

public class ResponseBodyEmitterReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final List<HttpMessageConverter<?>> sseMessageConverters;
    private final ReactiveTypeHandler reactiveHandler;
    private final List<ViewResolver> viewResolvers;
    private final LocaleResolver localeResolver;

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters) {
        this(messageConverters, ReactiveAdapterRegistry.getSharedInstance(), (TaskExecutor)new SyncTaskExecutor(), new ContentNegotiationManager());
    }

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters, ReactiveAdapterRegistry registry, TaskExecutor executor, ContentNegotiationManager manager) {
        this(messageConverters, registry, executor, manager, Collections.emptyList(), null);
    }

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters, ReactiveAdapterRegistry registry, TaskExecutor executor, ContentNegotiationManager manager, List<ViewResolver> viewResolvers, @Nullable LocaleResolver localeResolver) {
        Assert.notEmpty(messageConverters, (String)"HttpMessageConverter List must not be empty");
        this.sseMessageConverters = ResponseBodyEmitterReturnValueHandler.initSseConverters(messageConverters);
        this.reactiveHandler = new ReactiveTypeHandler(registry, executor, manager, null);
        this.viewResolvers = viewResolvers;
        this.localeResolver = localeResolver != null ? localeResolver : new AcceptHeaderLocaleResolver();
    }

    private static List<HttpMessageConverter<?>> initSseConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!converter.canWrite(String.class, MediaType.TEXT_PLAIN)) continue;
            return converters;
        }
        ArrayList result = new ArrayList(converters.size() + 1);
        result.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        result.addAll(converters);
        return result;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Class bodyType = ResponseEntity.class.isAssignableFrom(returnType.getParameterType()) ? ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[0]).resolve() : returnType.getParameterType();
        return bodyType != null && this.supportsBodyType(bodyType);
    }

    boolean supportsBodyType(Class<?> bodyType) {
        return ResponseBodyEmitter.class.isAssignableFrom(bodyType) || this.reactiveHandler.isReactiveType(bodyType);
    }

    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        DefaultSseEmitterHandler emitterHandler;
        ResponseBodyEmitter emitter;
        HttpServletRequest request;
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        Assert.state((response != null ? 1 : 0) != 0, (String)"No HttpServletResponse");
        Object outputMessage = new ServletServerHttpResponse(response);
        MediaType contentType = null;
        if (returnValue instanceof ResponseEntity) {
            ResponseEntity responseEntity = (ResponseEntity)returnValue;
            response.setStatus(responseEntity.getStatusCode().value());
            outputMessage.getHeaders().putAll(responseEntity.getHeaders());
            contentType = responseEntity.getHeaders().getContentType();
            returnValue = responseEntity.getBody();
            returnType = returnType.nested();
            if (returnValue == null) {
                mavContainer.setRequestHandled(true);
                outputMessage.flush();
                return;
            }
        }
        Assert.state(((request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)) != null ? 1 : 0) != 0, (String)"No ServletRequest");
        if (returnValue instanceof ResponseBodyEmitter) {
            ResponseBodyEmitter responseBodyEmitter;
            emitter = responseBodyEmitter = (ResponseBodyEmitter)returnValue;
        } else {
            emitter = this.reactiveHandler.handleValue(returnValue, returnType, contentType, mavContainer, webRequest);
            if (emitter == null) {
                outputMessage.getHeaders().forEach((headerName, headerValues) -> {
                    for (String headerValue : headerValues) {
                        response.addHeader(headerName, headerValue);
                    }
                });
                return;
            }
        }
        emitter.extendResponse((ServerHttpResponse)outputMessage);
        ShallowEtagHeaderFilter.disableContentCaching((ServletRequest)request);
        outputMessage = new StreamingServletServerHttpResponse((ServerHttpResponse)outputMessage);
        try {
            DeferredResult result = new DeferredResult(emitter.getTimeout());
            WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startDeferredResultProcessing(result, new Object[]{mavContainer});
            FragmentHandler handler = new FragmentHandler(request, response, this.viewResolvers, this.localeResolver);
            emitterHandler = new DefaultSseEmitterHandler(this.sseMessageConverters, handler, (ServerHttpResponse)outputMessage, result);
        }
        catch (Throwable ex) {
            emitter.initializeWithError(ex);
            throw ex;
        }
        emitter.initialize(emitterHandler);
    }

    private static class StreamingServletServerHttpResponse
    extends DelegatingServerHttpResponse {
        private final HttpHeaders mutableHeaders = new HttpHeaders();

        public StreamingServletServerHttpResponse(ServerHttpResponse delegate) {
            super(delegate);
            this.mutableHeaders.putAll(delegate.getHeaders());
        }

        public HttpHeaders getHeaders() {
            return this.mutableHeaders;
        }
    }

    private static final class FragmentHandler {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final List<ViewResolver> viewResolvers;
        private final Locale locale;
        private final Charset charset;
        private final ServletRequestAttributes requestAttributes;

        public FragmentHandler(HttpServletRequest request, HttpServletResponse response, List<ViewResolver> viewResolvers, LocaleResolver localeResolver) {
            this.request = request;
            this.response = response;
            this.viewResolvers = viewResolvers;
            this.charset = FragmentHandler.initCharset(response);
            this.locale = localeResolver.resolveLocale(request);
            this.requestAttributes = new ServletWebRequest(this.request);
        }

        private static Charset initCharset(HttpServletResponse response) {
            MediaType contentType;
            String s = response.getHeader("Content-Type");
            if (StringUtils.hasText((String)s) && (contentType = MediaType.valueOf((String)s)).getCharset() != null) {
                return contentType.getCharset();
            }
            return StandardCharsets.UTF_8;
        }

        public void handle(ModelAndView modelAndView) throws IOException {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.requestAttributes);
            try {
                FragmentHttpServletResponse fragmentResponse = new FragmentHttpServletResponse(this.response, this.charset);
                FragmentsRendering render = FragmentsRendering.fragments(List.of(modelAndView)).build();
                render.resolveNestedViews(this::resolveViewName, this.locale);
                render.render(modelAndView.getModel(), this.request, (HttpServletResponse)fragmentResponse);
                byte[] content = fragmentResponse.getFragmentContent();
                this.response.getOutputStream().write(content);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to render " + String.valueOf(modelAndView), ex);
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
            }
        }

        public @Nullable View resolveViewName(String viewName, Locale locale) throws Exception {
            for (ViewResolver resolver : this.viewResolvers) {
                View view = resolver.resolveViewName(viewName, locale);
                if (view == null) continue;
                return view;
            }
            return null;
        }
    }

    private static final class DefaultSseEmitterHandler
    implements ResponseBodyEmitter.Handler {
        private final List<HttpMessageConverter<?>> messageConverters;
        private final FragmentHandler fragmentHandler;
        private final ServerHttpResponse outputMessage;
        private final DeferredResult<?> deferredResult;

        public DefaultSseEmitterHandler(List<HttpMessageConverter<?>> messageConverters, FragmentHandler fragmentHandler, ServerHttpResponse outputMessage, DeferredResult<?> result) {
            this.messageConverters = messageConverters;
            this.fragmentHandler = fragmentHandler;
            this.outputMessage = outputMessage;
            this.deferredResult = result;
        }

        @Override
        public void send(Object data, @Nullable MediaType mediaType) throws IOException {
            this.sendInternal(data, mediaType);
            this.outputMessage.flush();
        }

        @Override
        public void send(Set<ResponseBodyEmitter.DataWithMediaType> items) throws IOException {
            for (ResponseBodyEmitter.DataWithMediaType item : items) {
                this.sendInternal(item.getData(), item.getMediaType());
            }
            this.outputMessage.flush();
        }

        private <T> void sendInternal(T data, @Nullable MediaType mediaType) throws IOException {
            if (data instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)data;
                this.fragmentHandler.handle(mav);
                return;
            }
            for (HttpMessageConverter<?> converter : this.messageConverters) {
                if (!converter.canWrite(data.getClass(), mediaType)) continue;
                converter.write(data, mediaType, (HttpOutputMessage)this.outputMessage);
                return;
            }
            throw new IllegalArgumentException("No suitable converter for " + String.valueOf(data.getClass()));
        }

        @Override
        public void complete() {
            try {
                this.outputMessage.flush();
                this.deferredResult.setResult(null);
            }
            catch (IOException ex) {
                this.deferredResult.setErrorResult((Object)ex);
            }
        }

        @Override
        public void completeWithError(Throwable failure) {
            this.deferredResult.setErrorResult((Object)failure);
        }

        @Override
        public void onTimeout(Runnable callback) {
            this.deferredResult.onTimeout(callback);
        }

        @Override
        public void onError(Consumer<Throwable> callback) {
            this.deferredResult.onError(callback);
        }

        @Override
        public void onCompletion(Runnable callback) {
            this.deferredResult.onCompletion(callback);
        }
    }

    private static final class FragmentServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        private FragmentServletOutputStream() {
        }

        public void write(int b) {
            this.outputStream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) {
            this.outputStream.write(b, off, len);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }

        public String toString(Charset charset) {
            return this.outputStream.toString(charset);
        }
    }

    private static final class FragmentHttpServletResponse
    extends HttpServletResponseWrapper {
        private final FragmentServletOutputStream outputStream = new FragmentServletOutputStream();
        private final PrintWriter writer = new PrintWriter((OutputStream)((Object)this.outputStream));
        private final Charset charset;

        public FragmentHttpServletResponse(HttpServletResponse delegate, Charset charset) {
            super(delegate);
            this.charset = charset;
        }

        public void setContentType(String type) {
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setCharacterEncoding(Charset encoding) {
        }

        public void setContentLength(int len) {
        }

        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() {
            return this.writer;
        }

        public byte[] getFragmentContent() {
            this.writer.flush();
            String content = this.outputStream.toString(this.charset);
            content = content.replace("\n", "\ndata:");
            return content.getBytes(this.charset);
        }
    }
}

