/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitterReturnValueHandler;

public class ResponseEntityReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final HttpEntityMethodProcessor httpEntityMethodProcessor;
    private final ResponseBodyEmitterReturnValueHandler responseBodyEmitterHandler;

    public ResponseEntityReturnValueHandler(HttpEntityMethodProcessor httpEntityMethodProcessor, ResponseBodyEmitterReturnValueHandler responseBodyEmitterHandler) {
        this.httpEntityMethodProcessor = httpEntityMethodProcessor;
        this.responseBodyEmitterHandler = responseBodyEmitterHandler;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.httpEntityMethodProcessor.supportsReturnType(returnType);
    }

    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest request) throws Exception {
        HttpEntity httpEntity;
        Object body2;
        if (returnValue instanceof HttpEntity && (body2 = (httpEntity = (HttpEntity)returnValue).getBody()) != null && this.responseBodyEmitterHandler.supportsBodyType(body2.getClass())) {
            this.responseBodyEmitterHandler.handleReturnValue(returnValue, returnType, mavContainer, request);
            return;
        }
        this.httpEntityMethodProcessor.handleReturnValue(returnValue, returnType, mavContainer, request);
    }
}

