/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.AbstractServerResponse;
import org.springframework.web.servlet.function.DefaultAsyncServerResponse;
import org.springframework.web.servlet.function.EntityResponse;
import org.springframework.web.servlet.function.ServerResponse;

final class DefaultEntityResponseBuilder<T>
implements EntityResponse.Builder<T> {
    private static final Type RESOURCE_REGION_LIST_TYPE = new ParameterizedTypeReference<List<ResourceRegion>>(){}.getType();
    private final T entity;
    private final Type entityType;
    private HttpStatusCode status = HttpStatus.OK;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, Cookie> cookies = new LinkedMultiValueMap();

    private DefaultEntityResponseBuilder(T entity, @Nullable Type entityType) {
        this.entity = entity;
        this.entityType = entityType != null ? entityType : entity.getClass();
    }

    @Override
    public EntityResponse.Builder<T> status(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode must not be null");
        this.status = status;
        return this;
    }

    @Override
    public EntityResponse.Builder<T> status(int status) {
        return this.status(HttpStatusCode.valueOf((int)status));
    }

    @Override
    public EntityResponse.Builder<T> cookie(Cookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie must not be null");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cookies(Consumer<MultiValueMap<String, Cookie>> cookiesConsumer) {
        Assert.notNull(cookiesConsumer, (String)"cookiesConsumer must not be null");
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> header(String headerName, String ... headerValues) {
        Assert.notNull((Object)headerName, (String)"headerName must not be null");
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public EntityResponse.Builder<T> headers(Consumer<HttpHeaders> headersConsumer) {
        Assert.notNull(headersConsumer, (String)"headersConsumer must not be null");
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(HttpMethod ... allowedMethods) {
        Assert.notNull((Object)allowedMethods, (String)"allowedMethods must not be null");
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(Set<HttpMethod> allowedMethods) {
        Assert.notNull(allowedMethods, (String)"allowedMethods must not be null");
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"contentType must not be null");
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> eTag(String tag) {
        this.headers.setETag(tag);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> lastModified(ZonedDateTime lastModified) {
        Assert.notNull((Object)lastModified, (String)"lastModified must not be null");
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> lastModified(Instant lastModified) {
        Assert.notNull((Object)lastModified, (String)"lastModified must not be null");
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> location(URI location) {
        Assert.notNull((Object)location, (String)"location must not be null");
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cacheControl(CacheControl cacheControl) {
        Assert.notNull((Object)cacheControl, (String)"cacheControl must not be null");
        this.headers.setCacheControl(cacheControl);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public EntityResponse<T> build() {
        ReactiveAdapter adapter;
        T t = this.entity;
        if (t instanceof CompletionStage) {
            CompletionStage completionStage = (CompletionStage)t;
            return new CompletionStageEntityResponse(this.status, this.headers, this.cookies, completionStage, this.entityType);
        }
        if (DefaultAsyncServerResponse.REACTIVE_STREAMS_PRESENT && (adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(this.entity.getClass())) != null) {
            Publisher publisher = adapter.toPublisher(this.entity);
            return new PublisherEntityResponse(this.status, this.headers, this.cookies, publisher, this.entityType);
        }
        return new DefaultEntityResponse<T>(this.status, this.headers, this.cookies, this.entity, this.entityType);
    }

    public static <T> EntityResponse.Builder<T> fromObject(T t) {
        return new DefaultEntityResponseBuilder<T>(t, null);
    }

    public static <T> EntityResponse.Builder<T> fromObject(T t, ParameterizedTypeReference<?> bodyType) {
        return new DefaultEntityResponseBuilder<T>(t, bodyType.getType());
    }

    private static class CompletionStageEntityResponse<T>
    extends DefaultEntityResponse<CompletionStage<T>> {
        public CompletionStageEntityResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, CompletionStage<T> entity, Type entityType) {
            super(statusCode, headers, cookies, entity, entityType);
        }

        @Override
        protected @Nullable ModelAndView writeToInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServerResponse.Context context) throws ServletException, IOException {
            DeferredResult<ServerResponse> deferredResult = this.createDeferredResult(servletRequest, servletResponse, context);
            DefaultAsyncServerResponse.writeAsync(servletRequest, servletResponse, deferredResult);
            return null;
        }

        private DeferredResult<ServerResponse> createDeferredResult(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) {
            DeferredResult result = new DeferredResult();
            ((CompletionStage)this.entity()).whenComplete((value, ex) -> {
                if (ex != null) {
                    ServerResponse errorResponse;
                    if (ex instanceof CompletionException && ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    if ((errorResponse = this.errorResponse((Throwable)ex, request)) != null) {
                        result.setResult((Object)errorResponse);
                    } else {
                        result.setErrorResult(ex);
                    }
                } else {
                    try {
                        this.tryWriteEntityWithMessageConverters(value, request, response, context);
                        result.setResult(null);
                    }
                    catch (ServletException | IOException writeException) {
                        result.setErrorResult((Object)writeException);
                    }
                }
            });
            return result;
        }
    }

    private static class PublisherEntityResponse<T>
    extends DefaultEntityResponse<Publisher<T>> {
        public PublisherEntityResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, Publisher<T> entity, Type entityType) {
            super(statusCode, headers, cookies, entity, entityType);
        }

        @Override
        protected @Nullable ModelAndView writeToInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServerResponse.Context context) throws ServletException, IOException {
            DeferredResult deferredResult = new DeferredResult();
            DefaultAsyncServerResponse.writeAsync(servletRequest, servletResponse, deferredResult);
            ((Publisher)this.entity()).subscribe((Subscriber)new DeferredResultSubscriber(servletRequest, servletResponse, context, deferredResult));
            return null;
        }

        private class DeferredResultSubscriber
        implements Subscriber<T> {
            private final HttpServletRequest servletRequest;
            private final HttpServletResponse servletResponse;
            private final ServerResponse.Context context;
            private final DeferredResult<?> deferredResult;
            private @Nullable Subscription subscription;

            public DeferredResultSubscriber(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServerResponse.Context context, DeferredResult<?> deferredResult) {
                this.servletRequest = servletRequest;
                this.servletResponse = new NoContentLengthResponseWrapper(servletResponse);
                this.context = context;
                this.deferredResult = deferredResult;
            }

            public void onSubscribe(Subscription s) {
                if (this.subscription == null) {
                    this.subscription = s;
                    this.subscription.request(1L);
                } else {
                    s.cancel();
                }
            }

            public void onNext(T t) {
                Assert.state((this.subscription != null ? 1 : 0) != 0, (String)"No subscription");
                try {
                    PublisherEntityResponse.this.tryWriteEntityWithMessageConverters(t, this.servletRequest, this.servletResponse, this.context);
                    this.servletResponse.getOutputStream().flush();
                    this.subscription.request(1L);
                }
                catch (ServletException | IOException ex) {
                    this.subscription.cancel();
                    this.deferredResult.setErrorResult((Object)ex);
                }
            }

            public void onError(Throwable t) {
                try {
                    PublisherEntityResponse.this.handleError(t, this.servletRequest, this.servletResponse, this.context);
                }
                catch (ServletException | IOException handlingThrowable) {
                    this.deferredResult.setErrorResult((Object)handlingThrowable);
                }
            }

            public void onComplete() {
                try {
                    this.servletResponse.getOutputStream().flush();
                    this.deferredResult.setResult(null);
                }
                catch (IOException ex) {
                    this.deferredResult.setErrorResult((Object)ex);
                }
            }
        }

        private static class NoContentLengthResponseWrapper
        extends HttpServletResponseWrapper {
            public NoContentLengthResponseWrapper(HttpServletResponse response) {
                super(response);
            }

            public void addIntHeader(String name, int value) {
                if (!"Content-Length".equals(name)) {
                    super.addIntHeader(name, value);
                }
            }

            public void addHeader(String name, String value) {
                if (!"Content-Length".equals(name)) {
                    super.addHeader(name, value);
                }
            }

            public void setContentLength(int len) {
            }

            public void setContentLengthLong(long len) {
            }
        }
    }

    private static class DefaultEntityResponse<T>
    extends AbstractServerResponse
    implements EntityResponse<T> {
        private final T entity;
        private final Type entityType;

        public DefaultEntityResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, T entity, Type entityType) {
            super(statusCode, headers, cookies);
            this.entity = entity;
            this.entityType = entityType;
        }

        @Override
        public T entity() {
            return this.entity;
        }

        @Override
        protected @Nullable ModelAndView writeToInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServerResponse.Context context) throws ServletException, IOException {
            this.writeEntityWithMessageConverters(this.entity, servletRequest, servletResponse, context);
            return null;
        }

        protected void writeEntityWithMessageConverters(Object entity, HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) throws ServletException, IOException {
            ServletServerHttpResponse serverResponse = new ServletServerHttpResponse(response);
            MediaType contentType = DefaultEntityResponse.getContentType(response);
            Class<?> entityClass = entity.getClass();
            Type entityType = this.entityType;
            if (entityClass != InputStreamResource.class && Resource.class.isAssignableFrom(entityClass)) {
                serverResponse.getHeaders().set("Accept-Ranges", "bytes");
                String rangeHeader = request.getHeader("Range");
                if (rangeHeader != null) {
                    Resource resource = (Resource)entity;
                    try {
                        List httpRanges = HttpRange.parseRanges((String)rangeHeader);
                        serverResponse.getServletResponse().setStatus(HttpStatus.PARTIAL_CONTENT.value());
                        entity = HttpRange.toResourceRegions((List)httpRanges, (Resource)resource);
                        entityClass = entity.getClass();
                        entityType = RESOURCE_REGION_LIST_TYPE;
                    }
                    catch (IllegalArgumentException ex) {
                        serverResponse.getHeaders().set("Content-Range", "bytes */" + resource.contentLength());
                        serverResponse.getServletResponse().setStatus(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.value());
                    }
                }
            }
            for (HttpMessageConverter<?> messageConverter : context.messageConverters()) {
                if (messageConverter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericMessageConverter = (GenericHttpMessageConverter)messageConverter;
                    if (!genericMessageConverter.canWrite(entityType, entityClass, contentType)) continue;
                    genericMessageConverter.write(entity, entityType, contentType, (HttpOutputMessage)serverResponse);
                    return;
                }
                if (messageConverter instanceof SmartHttpMessageConverter) {
                    SmartHttpMessageConverter smartMessageConverter = (SmartHttpMessageConverter)messageConverter;
                    ResolvableType resolvableType = ResolvableType.forType((Type)entityType);
                    if (!smartMessageConverter.canWrite(resolvableType, entityClass, contentType)) continue;
                    smartMessageConverter.write(entity, resolvableType, contentType, (HttpOutputMessage)serverResponse, null);
                    return;
                }
                if (!messageConverter.canWrite(entityClass, contentType)) continue;
                messageConverter.write(entity, contentType, (HttpOutputMessage)serverResponse);
                return;
            }
            List<MediaType> producibleMediaTypes = DefaultEntityResponse.producibleMediaTypes(context.messageConverters(), entityClass);
            throw new HttpMediaTypeNotAcceptableException(producibleMediaTypes);
        }

        private static @Nullable MediaType getContentType(HttpServletResponse response) {
            try {
                return MediaType.parseMediaType((String)response.getContentType()).removeQualityValue();
            }
            catch (InvalidMediaTypeException ex) {
                return null;
            }
        }

        protected void tryWriteEntityWithMessageConverters(Object entity, HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) throws ServletException, IOException {
            try {
                this.writeEntityWithMessageConverters(entity, request, response, context);
            }
            catch (ServletException | IOException ex) {
                this.handleError(ex, request, response, context);
            }
        }

        private static List<MediaType> producibleMediaTypes(List<HttpMessageConverter<?>> messageConverters, Class<?> entityClass) {
            return messageConverters.stream().filter(messageConverter -> messageConverter.canWrite(entityClass, null)).flatMap(messageConverter -> messageConverter.getSupportedMediaTypes(entityClass).stream()).toList();
        }
    }
}

