/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;

public class AcceptHeaderLocaleResolver
implements LocaleResolver {
    private final List<Locale> supportedLocales = new ArrayList<Locale>(4);
    @Nullable
    private Locale defaultLocale;

    public void setSupportedLocales(List<Locale> locales) {
        this.supportedLocales.clear();
        this.supportedLocales.addAll(locales);
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setDefaultLocale(@Nullable Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Nullable
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null && request.getHeader("Accept-Language") == null) {
            return defaultLocale;
        }
        Locale requestLocale = request.getLocale();
        if (this.isSupportedLocale(requestLocale)) {
            return requestLocale;
        }
        Locale supportedLocale = this.findSupportedLocale(request);
        if (supportedLocale != null) {
            return supportedLocale;
        }
        return defaultLocale != null ? defaultLocale : requestLocale;
    }

    private boolean isSupportedLocale(Locale locale) {
        List<Locale> supportedLocales = this.getSupportedLocales();
        return supportedLocales.isEmpty() || supportedLocales.contains(locale);
    }

    @Nullable
    private Locale findSupportedLocale(HttpServletRequest request) {
        Enumeration requestLocales = request.getLocales();
        List<Locale> supported = this.getSupportedLocales();
        Locale languageMatch = null;
        while (requestLocales.hasMoreElements()) {
            Locale locale = (Locale)requestLocales.nextElement();
            if (supported.contains(locale)) {
                return locale;
            }
            if (languageMatch != null) continue;
            for (Locale candidate : supported) {
                if (StringUtils.hasLength((String)candidate.getCountry()) || !candidate.getLanguage().equals(locale.getLanguage())) continue;
                languageMatch = candidate;
            }
        }
        return languageMatch;
    }

    @Override
    public void setLocale(HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable Locale locale) {
        throw new UnsupportedOperationException("Cannot change HTTP accept header - use a different locale resolution strategy");
    }
}

