/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.OrderComparator;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.DefaultResourceResolverChain;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.UrlPathHelper;

public class ResourceUrlProvider
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private UrlPathHelper pathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, ResourceHttpRequestHandler> handlerMap = new HashMap<String, ResourceHttpRequestHandler>();
    private boolean autodetect = true;

    public void setUrlPathHelper(UrlPathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }

    public UrlPathHelper getPathHelper() {
        return this.pathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setHandlerMap(Map<String, ResourceHttpRequestHandler> handlerMap) {
        if (handlerMap != null) {
            this.handlerMap.clear();
            this.handlerMap.putAll(handlerMap);
            this.autodetect = false;
        }
    }

    public Map<String, ResourceHttpRequestHandler> getHandlerMap() {
        return this.handlerMap;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isAutodetect()) {
            this.handlerMap.clear();
            this.detectResourceHandlers(event.getApplicationContext());
            if (this.handlerMap.isEmpty() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No resource handling mappings found");
            }
        }
    }

    protected void detectResourceHandlers(ApplicationContext appContext) {
        this.logger.debug((Object)"Looking for resource handler mappings");
        Map map = appContext.getBeansOfType(SimpleUrlHandlerMapping.class);
        ArrayList handlerMappings = new ArrayList(map.values());
        Collections.sort(handlerMappings, new OrderComparator());
        for (SimpleUrlHandlerMapping hm : handlerMappings) {
            for (String pattern : hm.getHandlerMap().keySet()) {
                Object handler = hm.getHandlerMap().get(pattern);
                if (!(handler instanceof ResourceHttpRequestHandler)) continue;
                ResourceHttpRequestHandler resourceHandler = (ResourceHttpRequestHandler)((Object)handler);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found resource handler mapping: URL pattern=\"" + pattern + "\", " + "locations=" + resourceHandler.getLocations() + ", " + "resolvers=" + resourceHandler.getResourceResolvers()));
                }
                this.handlerMap.put(pattern, resourceHandler);
            }
        }
    }

    public final String getForRequestUrl(HttpServletRequest request, String requestUrl) {
        int index;
        String pathWithinMapping;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for requestURL=" + requestUrl));
        }
        if ((pathWithinMapping = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE)) == null) {
            this.logger.trace((Object)"Request attribute with lookup path not found, calculating instead.");
            pathWithinMapping = this.getPathHelper().getLookupPathForRequest(request);
        }
        Assert.state(((index = this.getPathHelper().getRequestUri(request).indexOf(pathWithinMapping)) > 0 && index < requestUrl.length() ? 1 : 0) != 0, (String)("Failed to determine lookup path: " + requestUrl));
        String prefix = requestUrl.substring(0, index);
        String lookupPath = requestUrl.substring(index);
        String resolvedPath = this.getForLookupPath(lookupPath);
        return resolvedPath != null ? prefix + resolvedPath : null;
    }

    public final String getForLookupPath(String lookupPath) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for lookupPath=" + lookupPath));
        }
        for (String pattern : this.handlerMap.keySet()) {
            ResourceHttpRequestHandler handler;
            DefaultResourceResolverChain chain;
            String resolved;
            if (!this.getPathMatcher().match(pattern, lookupPath)) continue;
            String pathWithinMapping = this.getPathMatcher().extractPathWithinPattern(pattern, lookupPath);
            String pathMapping = lookupPath.substring(0, lookupPath.indexOf(pathWithinMapping));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking ResourceResolverChain for URL pattern=\"" + pattern + "\""));
            }
            if ((resolved = (chain = new DefaultResourceResolverChain((handler = this.handlerMap.get(pattern)).getResourceResolvers())).resolveUrlPath(pathWithinMapping, handler.getLocations())) == null) {
                throw new IllegalStateException("Failed to get public resource URL path for " + pathWithinMapping);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Resolved public resource URL path=\"" + resolved + "\""));
            }
            return pathMapping + resolved;
        }
        this.logger.debug((Object)"No matching resource mapping");
        return null;
    }
}

