/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles3;

import java.util.LinkedList;
import java.util.List;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.dao.CachingLocaleUrlDefinitionDAO;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.el.ELAttributeEvaluator;
import org.apache.tiles.el.ScopeELResolver;
import org.apache.tiles.el.TilesContextBeanELResolver;
import org.apache.tiles.el.TilesContextELResolver;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.extras.complete.CompleteAutoloadTilesContainerFactory;
import org.apache.tiles.extras.complete.CompleteAutoloadTilesInitializer;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.preparer.factory.PreparerFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationContextAware;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.startup.DefaultTilesInitializer;
import org.apache.tiles.startup.TilesInitializer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.tiles3.SpringLocaleResolver;
import org.springframework.web.servlet.view.tiles3.SpringWildcardServletTilesApplicationContext;

public class TilesConfigurer
implements ServletContextAware,
InitializingBean,
DisposableBean {
    private static final boolean tilesElPresent = ClassUtils.isPresent((String)"javax.servlet.jsp.JspApplicationContext", (ClassLoader)TilesConfigurer.class.getClassLoader()) && ClassUtils.isPresent((String)"org.apache.tiles.el.ELAttributeEvaluator", (ClassLoader)TilesConfigurer.class.getClassLoader());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TilesInitializer tilesInitializer;
    private String[] definitions;
    private boolean checkRefresh = false;
    private boolean validateDefinitions = true;
    private Class<? extends DefinitionsFactory> definitionsFactoryClass;
    private Class<? extends PreparerFactory> preparerFactoryClass;
    private boolean useMutableTilesContainer = false;
    private ServletContext servletContext;

    public void setTilesInitializer(TilesInitializer tilesInitializer) {
        this.tilesInitializer = tilesInitializer;
    }

    public void setCompleteAutoload(boolean completeAutoload) {
        if (completeAutoload) {
            try {
                this.tilesInitializer = new SpringCompleteAutoloadTilesInitializer();
            }
            catch (Exception ex) {
                throw new IllegalStateException("tiles-extras 3.x not available", ex);
            }
        } else {
            this.tilesInitializer = null;
        }
    }

    public void setDefinitions(String[] definitions) {
        this.definitions = definitions;
    }

    public void setCheckRefresh(boolean checkRefresh) {
        this.checkRefresh = checkRefresh;
    }

    public void setValidateDefinitions(boolean validateDefinitions) {
        this.validateDefinitions = validateDefinitions;
    }

    public void setDefinitionsFactoryClass(Class<? extends DefinitionsFactory> definitionsFactoryClass) {
        this.definitionsFactoryClass = definitionsFactoryClass;
    }

    public void setPreparerFactoryClass(Class<? extends PreparerFactory> preparerFactoryClass) {
        this.preparerFactoryClass = preparerFactoryClass;
    }

    public void setUseMutableTilesContainer(boolean useMutableTilesContainer) {
        this.useMutableTilesContainer = useMutableTilesContainer;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws TilesException {
        SpringWildcardServletTilesApplicationContext preliminaryContext = new SpringWildcardServletTilesApplicationContext(this.servletContext);
        if (this.tilesInitializer == null) {
            this.tilesInitializer = new SpringTilesInitializer();
        }
        this.tilesInitializer.initialize((ApplicationContext)preliminaryContext);
    }

    public void destroy() throws TilesException {
        this.tilesInitializer.destroy();
    }

    private static class CompositeELResolverImpl
    extends CompositeELResolver {
        public CompositeELResolverImpl() {
            this.add((ELResolver)new ScopeELResolver());
            this.add((ELResolver)new TilesContextELResolver((ELResolver)new TilesContextBeanELResolver()));
            this.add((ELResolver)new TilesContextBeanELResolver());
            this.add((ELResolver)new ArrayELResolver(false));
            this.add((ELResolver)new ListELResolver(false));
            this.add((ELResolver)new MapELResolver(false));
            this.add((ELResolver)new ResourceBundleELResolver());
            this.add((ELResolver)new BeanELResolver(false));
        }
    }

    private class TilesElActivator {
        private TilesElActivator() {
        }

        public AttributeEvaluator createEvaluator() {
            try {
                JspFactory factory = JspFactory.getDefaultFactory();
                if (factory != null && factory.getJspApplicationContext(TilesConfigurer.this.servletContext).getExpressionFactory() != null) {
                    TilesConfigurer.this.logger.info((Object)"Found JSP 2.1 ExpressionFactory");
                    ELAttributeEvaluator evaluator = new ELAttributeEvaluator();
                    evaluator.setExpressionFactory(factory.getJspApplicationContext(TilesConfigurer.this.servletContext).getExpressionFactory());
                    evaluator.setResolver((ELResolver)new CompositeELResolverImpl());
                    return evaluator;
                }
            }
            catch (Throwable ex) {
                TilesConfigurer.this.logger.warn((Object)"Could not obtain JSP 2.1 ExpressionFactory", ex);
            }
            return null;
        }
    }

    private class SpringCompleteAutoloadTilesContainerFactory
    extends CompleteAutoloadTilesContainerFactory {
        private SpringCompleteAutoloadTilesContainerFactory() {
        }

        public TilesContainer createContainer(ApplicationContext applicationContext) {
            CachingTilesContainer cachingContainer = (CachingTilesContainer)super.createContainer(applicationContext);
            BasicTilesContainer tilesContainer = (BasicTilesContainer)cachingContainer.getWrappedContainer();
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)tilesContainer.getDefinitionsFactory());
            if (bw.isWritableProperty("localeResolver")) {
                bw.setPropertyValue("localeResolver", (Object)new SpringLocaleResolver());
            }
            return tilesContainer;
        }
    }

    private class SpringCompleteAutoloadTilesInitializer
    extends CompleteAutoloadTilesInitializer {
        private SpringCompleteAutoloadTilesInitializer() {
        }

        protected AbstractTilesContainerFactory createContainerFactory(ApplicationContext context) {
            return new SpringCompleteAutoloadTilesContainerFactory();
        }
    }

    private class SpringTilesContainerFactory
    extends BasicTilesContainerFactory {
        private SpringTilesContainerFactory() {
        }

        public TilesContainer createContainer(ApplicationContext context) {
            TilesContainer container = super.createContainer(context);
            return TilesConfigurer.this.useMutableTilesContainer ? new CachingTilesContainer(container) : container;
        }

        protected List<ApplicationResource> getSources(ApplicationContext applicationContext) {
            if (TilesConfigurer.this.definitions != null) {
                LinkedList<ApplicationResource> result = new LinkedList<ApplicationResource>();
                for (String definition : TilesConfigurer.this.definitions) {
                    result.addAll(applicationContext.getResources(definition));
                }
                return result;
            }
            return super.getSources(applicationContext);
        }

        protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(ApplicationContext applicationContext, LocaleResolver resolver) {
            BaseLocaleUrlDefinitionDAO dao = super.instantiateLocaleDefinitionDao(applicationContext, resolver);
            if (TilesConfigurer.this.checkRefresh && dao instanceof CachingLocaleUrlDefinitionDAO) {
                ((CachingLocaleUrlDefinitionDAO)dao).setCheckRefresh(TilesConfigurer.this.checkRefresh);
            }
            return dao;
        }

        protected DefinitionsReader createDefinitionsReader(ApplicationContext context) {
            DigesterDefinitionsReader reader = (DigesterDefinitionsReader)super.createDefinitionsReader(context);
            reader.setValidating(TilesConfigurer.this.validateDefinitions);
            return reader;
        }

        protected DefinitionsFactory createDefinitionsFactory(ApplicationContext applicationContext, LocaleResolver resolver) {
            if (TilesConfigurer.this.definitionsFactoryClass != null) {
                BeanWrapper bw;
                DefinitionsFactory factory = (DefinitionsFactory)BeanUtils.instantiate((Class)TilesConfigurer.this.definitionsFactoryClass);
                if (factory instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)factory).setApplicationContext(applicationContext);
                }
                if ((bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)factory)).isWritableProperty("localeResolver")) {
                    bw.setPropertyValue("localeResolver", (Object)resolver);
                }
                if (bw.isWritableProperty("definitionDAO")) {
                    bw.setPropertyValue("definitionDAO", (Object)this.createLocaleDefinitionDao(applicationContext, resolver));
                }
                return factory;
            }
            return super.createDefinitionsFactory(applicationContext, resolver);
        }

        protected PreparerFactory createPreparerFactory(ApplicationContext context) {
            if (TilesConfigurer.this.preparerFactoryClass != null) {
                return (PreparerFactory)BeanUtils.instantiate((Class)TilesConfigurer.this.preparerFactoryClass);
            }
            return super.createPreparerFactory(context);
        }

        protected LocaleResolver createLocaleResolver(ApplicationContext context) {
            return new SpringLocaleResolver();
        }

        protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(ApplicationContext context, LocaleResolver resolver) {
            return new BasicAttributeEvaluatorFactory(this.createELEvaluator(context));
        }

        private AttributeEvaluator createELEvaluator(ApplicationContext context) {
            AttributeEvaluator evaluator;
            if (tilesElPresent && (evaluator = new TilesElActivator().createEvaluator()) != null) {
                return evaluator;
            }
            return new DirectAttributeEvaluator();
        }
    }

    private class SpringTilesInitializer
    extends DefaultTilesInitializer {
        private SpringTilesInitializer() {
        }

        protected AbstractTilesContainerFactory createContainerFactory(ApplicationContext context) {
            return new SpringTilesContainerFactory();
        }
    }
}

