/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.core.JdkVersion;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.ValueFormatter;

abstract class SelectedValueComparator {
    SelectedValueComparator() {
    }

    public static boolean isSelected(BindStatus bindStatus, Object candidateValue) {
        if (bindStatus == null) {
            return candidateValue == null;
        }
        Object boundValue = bindStatus.getValue();
        if (ObjectUtils.nullSafeEquals((Object)boundValue, (Object)candidateValue)) {
            return true;
        }
        Object actualValue = bindStatus.getActualValue();
        if (actualValue != boundValue && ObjectUtils.nullSafeEquals((Object)actualValue, (Object)candidateValue)) {
            return true;
        }
        if (actualValue != null) {
            boundValue = actualValue;
        } else if (boundValue == null) {
            return false;
        }
        boolean selected = false;
        if (boundValue.getClass().isArray()) {
            selected = SelectedValueComparator.collectionCompare(CollectionUtils.arrayToList((Object)boundValue), candidateValue, bindStatus);
        } else if (boundValue instanceof Collection) {
            selected = SelectedValueComparator.collectionCompare((Collection)boundValue, candidateValue, bindStatus);
        } else if (boundValue instanceof Map) {
            selected = SelectedValueComparator.mapCompare((Map)boundValue, candidateValue, bindStatus);
        }
        if (!selected) {
            selected = SelectedValueComparator.exhaustiveCompare(boundValue, candidateValue, bindStatus.getEditor(), null);
        }
        return selected;
    }

    private static boolean collectionCompare(Collection boundCollection, Object candidateValue, BindStatus bindStatus) {
        try {
            if (boundCollection.contains(candidateValue)) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return SelectedValueComparator.exhaustiveCollectionCompare(boundCollection, candidateValue, bindStatus);
    }

    private static boolean mapCompare(Map boundMap, Object candidateValue, BindStatus bindStatus) {
        try {
            if (boundMap.containsKey(candidateValue)) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return SelectedValueComparator.exhaustiveCollectionCompare(boundMap.keySet(), candidateValue, bindStatus);
    }

    private static boolean exhaustiveCollectionCompare(Collection collection, Object candidateValue, BindStatus bindStatus) {
        PropertyEditorRegistry editorRegistry = null;
        if (bindStatus.getErrors() instanceof BindingResult) {
            editorRegistry = ((BindingResult)bindStatus.getErrors()).getPropertyEditorRegistry();
        }
        HashMap convertedValueCache = new HashMap(1);
        PropertyEditor editor = null;
        boolean candidateIsString = candidateValue instanceof String;
        if (editorRegistry != null && !candidateIsString) {
            editor = editorRegistry.findCustomEditor(candidateValue.getClass(), bindStatus.getPath());
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (editor == null && editorRegistry != null && element != null && candidateIsString) {
                editor = editorRegistry.findCustomEditor(element.getClass(), bindStatus.getPath());
            }
            if (!SelectedValueComparator.exhaustiveCompare(element, candidateValue, editor, convertedValueCache)) continue;
            return true;
        }
        return false;
    }

    private static boolean exhaustiveCompare(Object boundValue, Object candidate, PropertyEditor editor, Map convertedValueCache) {
        String candidateDisplayString = ValueFormatter.getDisplayString(candidate, editor, false);
        if (boundValue instanceof LabeledEnum) {
            LabeledEnum labeledEnum = (LabeledEnum)boundValue;
            String enumCodeAsString = ObjectUtils.getDisplayString((Object)labeledEnum.getCode());
            if (enumCodeAsString.equals(candidateDisplayString)) {
                return true;
            }
            String enumLabelAsString = ObjectUtils.getDisplayString((Object)labeledEnum.getLabel());
            if (enumLabelAsString.equals(candidateDisplayString)) {
                return true;
            }
        } else if (JdkVersion.isAtLeastJava15() && boundValue.getClass().isEnum()) {
            Enum boundEnum = (Enum)boundValue;
            String enumCodeAsString = ObjectUtils.getDisplayString((Object)boundEnum.name());
            if (enumCodeAsString.equals(candidateDisplayString)) {
                return true;
            }
            String enumLabelAsString = ObjectUtils.getDisplayString((Object)boundEnum.toString());
            if (enumLabelAsString.equals(candidateDisplayString)) {
                return true;
            }
        } else {
            if (ObjectUtils.getDisplayString((Object)boundValue).equals(candidateDisplayString)) {
                return true;
            }
            if (editor != null && candidate instanceof String) {
                String candidateAsString = (String)candidate;
                Object candidateAsValue = null;
                if (convertedValueCache != null && convertedValueCache.containsKey(editor)) {
                    candidateAsValue = convertedValueCache.get(editor);
                } else {
                    editor.setAsText(candidateAsString);
                    candidateAsValue = editor.getValue();
                    if (convertedValueCache != null) {
                        convertedValueCache.put(editor, candidateAsValue);
                    }
                }
                if (ObjectUtils.nullSafeEquals((Object)boundValue, (Object)candidateAsValue)) {
                    return true;
                }
            }
        }
        return false;
    }
}

