/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.beans.PropertyEditor;
import javax.servlet.jsp.JspException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractCheckedElementTag
extends AbstractHtmlInputElementTag {
    protected void renderFromValue(Object value, TagWriter tagWriter) throws JspException {
        this.renderFromValue(value, value, tagWriter);
    }

    protected void renderFromValue(Object item, Object value, TagWriter tagWriter) throws JspException {
        PropertyEditorRegistry editorRegistry;
        BindStatus bindStatus = this.getBindStatus();
        PropertyEditor editor = null;
        if (value != null && bindStatus.getErrors() instanceof BindingResult && (editorRegistry = ((BindingResult)bindStatus.getErrors()).getPropertyEditorRegistry()) != null) {
            editor = editorRegistry.findCustomEditor(value.getClass(), bindStatus.getPath());
        }
        tagWriter.writeAttribute("value", this.getDisplayString(value, editor));
        if (this.isOptionSelected(value) || value != item && this.isOptionSelected(item)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    private boolean isOptionSelected(Object value) throws JspException {
        return SelectedValueComparator.isSelected(this.getBindStatus(), value);
    }

    protected void renderFromBoolean(Boolean boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", "true");
        if (boundValue.booleanValue()) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(this.getName(), this.pageContext);
    }

    protected abstract int writeTagContent(TagWriter var1) throws JspException;
}

