/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.WebUtils;

abstract class ServletAnnotationMappingUtils {
    ServletAnnotationMappingUtils() {
    }

    public static boolean checkRequestMethod(RequestMethod[] methods, HttpServletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])methods)) {
            boolean match = false;
            for (RequestMethod method : methods) {
                if (!method.toString().equals(request.getMethod().toUpperCase())) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkParameters(String[] params, HttpServletRequest request) {
        if (!ObjectUtils.isEmpty((Object[])params)) {
            for (String param : params) {
                int separator = param.indexOf(61);
                if (separator == -1) {
                    if (!(param.startsWith("!") ? WebUtils.hasSubmitParameter((ServletRequest)request, (String)param.substring(1)) : !WebUtils.hasSubmitParameter((ServletRequest)request, (String)param))) continue;
                    return false;
                }
                String key = param.substring(0, separator);
                String value = param.substring(separator + 1);
                if (value.equals(request.getParameter(key))) continue;
                return false;
            }
        }
        return true;
    }
}

