/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SourceFilteringListener;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletRequestHandledEvent;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.servlet.HttpServletBean;
import org.springframework.web.util.NestedServletException;
import org.springframework.web.util.WebUtils;

public abstract class FrameworkServlet
extends HttpServletBean
implements ApplicationListener {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = XmlWebApplicationContext.class;
    public static final String SERVLET_CONTEXT_PREFIX = FrameworkServlet.class.getName() + ".CONTEXT.";
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private boolean publishContext = true;
    private boolean publishEvents = true;
    private boolean dispatchOptionsRequest = false;
    private boolean dispatchTraceRequest = false;
    private WebApplicationContext webApplicationContext;
    private boolean refreshEventReceived = false;

    public void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace != null ? this.namespace : this.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setPublishContext(boolean publishContext) {
        this.publishContext = publishContext;
    }

    public void setPublishEvents(boolean publishEvents) {
        this.publishEvents = publishEvents;
    }

    public void setDispatchOptionsRequest(boolean dispatchOptionsRequest) {
        this.dispatchOptionsRequest = dispatchOptionsRequest;
    }

    public void setDispatchTraceRequest(boolean dispatchTraceRequest) {
        this.dispatchTraceRequest = dispatchTraceRequest;
    }

    protected final void initServletBean() throws ServletException, BeansException {
        this.getServletContext().log("Initializing Spring FrameworkServlet '" + this.getServletName() + "'");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("FrameworkServlet '" + this.getServletName() + "': initialization started"));
        }
        long startTime = System.currentTimeMillis();
        try {
            this.webApplicationContext = this.initWebApplicationContext();
            this.initFrameworkServlet();
        }
        catch (ServletException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        catch (BeansException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        if (this.logger.isInfoEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info((Object)("FrameworkServlet '" + this.getServletName() + "': initialization completed in " + elapsedTime + " ms"));
        }
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException {
        WebApplicationContext parent = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        WebApplicationContext wac = this.createWebApplicationContext(parent);
        if (!this.refreshEventReceived) {
            this.onRefresh((ApplicationContext)wac);
        }
        if (this.publishContext) {
            String attrName = this.getServletContextAttributeName();
            this.getServletContext().setAttribute(attrName, (Object)wac);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Published WebApplicationContext of servlet '" + this.getServletName() + "' as ServletContext attribute with name [" + attrName + "]"));
            }
        }
        return wac;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext parent) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Servlet with name '" + this.getServletName() + "' will try to create custom WebApplicationContext context of class '" + this.getContextClass().getName() + "'" + ", using parent context [" + parent + "]"));
        }
        if (!ConfigurableWebApplicationContext.class.isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in servlet with name '" + this.getServletName() + "': custom WebApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)this.getContextClass());
        wac.setParent((ApplicationContext)parent);
        wac.setServletContext(this.getServletContext());
        wac.setServletConfig(this.getServletConfig());
        wac.setNamespace(this.getNamespace());
        wac.setConfigLocation(this.getContextConfigLocation());
        wac.addApplicationListener((ApplicationListener)new SourceFilteringListener((Object)wac, (ApplicationListener)this));
        this.postProcessWebApplicationContext(wac);
        wac.refresh();
        return wac;
    }

    protected void postProcessWebApplicationContext(ConfigurableWebApplicationContext wac) {
    }

    public String getServletContextAttributeName() {
        return SERVLET_CONTEXT_PREFIX + this.getServletName();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
    }

    public void refresh() throws BeansException {
        WebApplicationContext wac = this.getWebApplicationContext();
        if (!(wac instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("WebApplicationContext does not support refresh: " + wac);
        }
        ((ConfigurableApplicationContext)wac).refresh();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.refreshEventReceived = true;
            this.onRefresh(((ContextRefreshedEvent)event).getApplicationContext());
        }
    }

    protected void onRefresh(ApplicationContext context) throws BeansException {
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected final void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected final void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doOptions(request, response);
        if (this.dispatchOptionsRequest) {
            this.processRequest(request, response);
        }
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doTrace(request, response);
        if (this.dispatchTraceRequest) {
            this.processRequest(request, response);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Throwable failureCause;
        long startTime;
        block11: {
            block9: {
                startTime = System.currentTimeMillis();
                failureCause = null;
                try {
                    try {
                        this.doService(request, response);
                    }
                    catch (ServletException ex) {
                        failureCause = ex;
                        throw ex;
                    }
                    catch (IOException ex) {
                        failureCause = ex;
                        throw ex;
                    }
                    catch (Throwable ex) {
                        failureCause = ex;
                        throw new NestedServletException("Request processing failed", ex);
                    }
                    Object var8_5 = null;
                    if (failureCause == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    if (failureCause != null) {
                        this.logger.debug((Object)"Could not complete request", failureCause);
                    } else {
                        this.logger.debug((Object)"Successfully completed request");
                    }
                    if (!this.publishEvents) throw throwable;
                    long processingTime = System.currentTimeMillis() - startTime;
                    this.webApplicationContext.publishEvent((ApplicationEvent)new ServletRequestHandledEvent((Object)this, request.getRequestURI(), request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName(), WebUtils.getSessionId((HttpServletRequest)request), this.getUsernameForRequest(request), processingTime, failureCause));
                    throw throwable;
                }
                this.logger.debug((Object)"Could not complete request", failureCause);
                break block11;
            }
            this.logger.debug((Object)"Successfully completed request");
        }
        if (!this.publishEvents) return;
        long processingTime = System.currentTimeMillis() - startTime;
        this.webApplicationContext.publishEvent((ApplicationEvent)new ServletRequestHandledEvent((Object)this, request.getRequestURI(), request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName(), WebUtils.getSessionId((HttpServletRequest)request), this.getUsernameForRequest(request), processingTime, failureCause));
    }

    protected String getUsernameForRequest(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        return userPrincipal != null ? userPrincipal.getName() : null;
    }

    protected abstract void doService(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public void destroy() {
        this.getServletContext().log("Destroying Spring FrameworkServlet '" + this.getServletName() + "'");
        if (this.webApplicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.webApplicationContext).close();
        }
    }
}

