/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.core.JdkVersion;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.ui.context.ThemeSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class DispatcherServlet
extends FrameworkServlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    public static final String LOCALE_RESOLVER_BEAN_NAME = "localeResolver";
    public static final String THEME_RESOLVER_BEAN_NAME = "themeResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String REQUEST_TO_VIEW_NAME_TRANSLATOR_BEAN_NAME = "viewNameTranslator";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String HANDLER_EXECUTION_CHAIN_ATTRIBUTE = DispatcherServlet.class.getName() + ".HANDLER";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = DispatcherServlet.class.getName() + ".CONTEXT";
    public static final String LOCALE_RESOLVER_ATTRIBUTE = DispatcherServlet.class.getName() + ".LOCALE_RESOLVER";
    public static final String THEME_RESOLVER_ATTRIBUTE = DispatcherServlet.class.getName() + ".THEME_RESOLVER";
    public static final String THEME_SOURCE_ATTRIBUTE = DispatcherServlet.class.getName() + ".THEME_SOURCE";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    private static final String DEFAULT_STRATEGIES_PATH = "DispatcherServlet.properties";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private static final Properties defaultStrategies;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private boolean cleanupAfterInclude = true;
    private boolean threadContextInheritable = false;
    private MultipartResolver multipartResolver;
    private LocaleResolver localeResolver;
    private ThemeResolver themeResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private RequestToViewNameTranslator viewNameTranslator;
    private List viewResolvers;

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerAdapters(boolean detectAllHandlerAdapters) {
        this.detectAllHandlerAdapters = detectAllHandlerAdapters;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    public void setCleanupAfterInclude(boolean cleanupAfterInclude) {
        this.cleanupAfterInclude = cleanupAfterInclude;
    }

    public void setThreadContextInheritable(boolean threadContextInheritable) {
        this.threadContextInheritable = threadContextInheritable;
    }

    protected void onRefresh(ApplicationContext context) throws BeansException {
        this.initStrategies(context);
    }

    protected void initStrategies(ApplicationContext context) {
        this.initMultipartResolver(context);
        this.initLocaleResolver(context);
        this.initThemeResolver(context);
        this.initHandlerMappings(context);
        this.initHandlerAdapters(context);
        this.initHandlerExceptionResolvers(context);
        this.initRequestToViewNameTranslator(context);
        this.initViewResolvers(context);
    }

    private void initMultipartResolver(ApplicationContext context) {
        block3: {
            try {
                this.multipartResolver = (MultipartResolver)context.getBean(MULTIPART_RESOLVER_BEAN_NAME, MultipartResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.multipartResolver = null;
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initLocaleResolver(ApplicationContext context) {
        block3: {
            try {
                this.localeResolver = (LocaleResolver)context.getBean(LOCALE_RESOLVER_BEAN_NAME, LocaleResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using LocaleResolver [" + this.localeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.localeResolver = (LocaleResolver)this.getDefaultStrategy(context, LocaleResolver.class);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate LocaleResolver with name 'localeResolver': using default [" + this.localeResolver + "]"));
            }
        }
    }

    private void initThemeResolver(ApplicationContext context) {
        block3: {
            try {
                this.themeResolver = (ThemeResolver)context.getBean(THEME_RESOLVER_BEAN_NAME, ThemeResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using ThemeResolver [" + this.themeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.themeResolver = (ThemeResolver)this.getDefaultStrategy(context, ThemeResolver.class);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate ThemeResolver with name 'themeResolver': using default [" + this.themeResolver + "]"));
            }
        }
    }

    private void initHandlerMappings(ApplicationContext context) {
        this.handlerMappings = null;
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)HandlerMapping.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerMappings, new OrderComparator());
            }
        } else {
            try {
                Object hm = context.getBean(HANDLER_MAPPING_BEAN_NAME, HandlerMapping.class);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            this.handlerMappings = this.getDefaultStrategies(context, HandlerMapping.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerMappings found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters(ApplicationContext context) {
        this.handlerAdapters = null;
        if (this.detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)HandlerAdapter.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerAdapters = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerAdapters, new OrderComparator());
            }
        } else {
            try {
                Object ha = context.getBean(HANDLER_ADAPTER_BEAN_NAME, HandlerAdapter.class);
                this.handlerAdapters = Collections.singletonList(ha);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerAdapters == null) {
            this.handlerAdapters = this.getDefaultStrategies(context, HandlerAdapter.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerAdapters found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers(ApplicationContext context) {
        this.handlerExceptionResolvers = null;
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)HandlerExceptionResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
            }
        } else {
            try {
                Object her = context.getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME, HandlerExceptionResolver.class);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerExceptionResolvers == null) {
            this.handlerExceptionResolvers = this.getDefaultStrategies(context, HandlerExceptionResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerExceptionResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initRequestToViewNameTranslator(ApplicationContext context) {
        block3: {
            try {
                this.viewNameTranslator = (RequestToViewNameTranslator)context.getBean(REQUEST_TO_VIEW_NAME_TRANSLATOR_BEAN_NAME, RequestToViewNameTranslator.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using RequestToViewNameTranslator [" + this.viewNameTranslator + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.viewNameTranslator = (RequestToViewNameTranslator)this.getDefaultStrategy(context, RequestToViewNameTranslator.class);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate RequestToViewNameTranslator with name 'viewNameTranslator': using default [" + this.viewNameTranslator + "]"));
            }
        }
    }

    private void initViewResolvers(ApplicationContext context) {
        this.viewResolvers = null;
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, (Class)ViewResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.viewResolvers, new OrderComparator());
            }
        } else {
            try {
                Object vr = context.getBean(VIEW_RESOLVER_BEAN_NAME, ViewResolver.class);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = this.getDefaultStrategies(context, ViewResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No ViewResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    public final ThemeSource getThemeSource() {
        if (this.getWebApplicationContext() instanceof ThemeSource) {
            return (ThemeSource)this.getWebApplicationContext();
        }
        return null;
    }

    public final MultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    protected Object getDefaultStrategy(ApplicationContext context, Class strategyInterface) throws BeansException {
        List strategies = this.getDefaultStrategies(context, strategyInterface);
        if (strategies.size() != 1) {
            throw new BeanInitializationException("DispatcherServlet needs exactly 1 strategy for interface [" + strategyInterface.getName() + "]");
        }
        return strategies.get(0);
    }

    protected List getDefaultStrategies(ApplicationContext context, Class strategyInterface) throws BeansException {
        String key = strategyInterface.getName();
        ArrayList<Object> strategies = null;
        String value = defaultStrategies.getProperty(key);
        if (value != null) {
            String[] classNames = StringUtils.commaDelimitedListToStringArray((String)value);
            strategies = new ArrayList<Object>(classNames.length);
            for (int i = 0; i < classNames.length; ++i) {
                String className = classNames[i];
                if (JdkVersion.getMajorJavaVersion() < 2 && className.indexOf("Annotation") != -1) continue;
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)(class$org$springframework$web$servlet$DispatcherServlet == null ? DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet") : class$org$springframework$web$servlet$DispatcherServlet).getClassLoader());
                    Object strategy = this.createDefaultStrategy(context, clazz);
                    strategies.add(strategy);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanInitializationException("Could not find DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)ex);
                }
                catch (LinkageError err) {
                    throw new BeanInitializationException("Error loading DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]: problem with class file or dependent class", (Throwable)err);
                }
            }
        } else {
            strategies = Collections.EMPTY_LIST;
        }
        return strategies;
    }

    protected Object createDefaultStrategy(ApplicationContext context, Class clazz) throws BeansException {
        return context.getAutowireCapableBeanFactory().createBean(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            String requestUri = new UrlPathHelper().getRequestUri(request);
            this.logger.debug((Object)("DispatcherServlet with name '" + this.getServletName() + "' received request for [" + requestUri + "]"));
        }
        HashMap<String, Object> attributesSnapshot = null;
        if (WebUtils.isIncludeRequest((ServletRequest)request)) {
            this.logger.debug((Object)"Taking snapshot of request attributes before include");
            attributesSnapshot = new HashMap<String, Object>();
            Enumeration attrNames = request.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                if (!this.cleanupAfterInclude && !attrName.startsWith("org.springframework.web.servlet")) continue;
                attributesSnapshot.put(attrName, request.getAttribute(attrName));
            }
        }
        request.setAttribute(WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getWebApplicationContext());
        request.setAttribute(LOCALE_RESOLVER_ATTRIBUTE, (Object)this.localeResolver);
        request.setAttribute(THEME_RESOLVER_ATTRIBUTE, (Object)this.themeResolver);
        request.setAttribute(THEME_SOURCE_ATTRIBUTE, (Object)this.getThemeSource());
        try {
            this.doDispatch(request, response);
            Object var7_6 = null;
            if (attributesSnapshot != null) {
                this.restoreAttributesAfterInclude(request, attributesSnapshot);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (attributesSnapshot != null) {
                this.restoreAttributesAfterInclude(request, attributesSnapshot);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            HandlerExecutionChain mappedHandler = this.getHandler(request, true);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.logger.debug((Object)"No handler found in getLastModified");
                return -1L;
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            long lastModified = ha.getLastModified(request, mappedHandler.getHandler());
            if (this.logger.isDebugEnabled()) {
                String requestUri = new UrlPathHelper().getRequestUri(request);
                this.logger.debug((Object)("Last-Modified value for [" + requestUri + "] is: " + lastModified));
            }
            return lastModified;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Exception thrown in getLastModified", (Throwable)ex);
            return -1L;
        }
    }

    protected LocaleContext buildLocaleContext(final HttpServletRequest request) {
        return new LocaleContext(){

            public Locale getLocale() {
                return DispatcherServlet.this.localeResolver.resolveLocale(request);
            }

            public String toString() {
                return this.getLocale().toString();
            }
        };
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (request instanceof MultipartHttpServletRequest) {
                this.logger.debug((Object)"Request is already a MultipartHttpServletRequest - if not in a forward, this typically results from an additional MultipartFilter in web.xml");
            } else {
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    protected void cleanupMultipart(HttpServletRequest request) {
        if (request instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)request);
        }
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request, boolean cache) throws Exception {
        HandlerExecutionChain handler = (HandlerExecutionChain)request.getAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
        if (handler != null) {
            if (!cache) {
                request.removeAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
            }
            return handler;
        }
        Iterator it = this.handlerMappings.iterator();
        while (it.hasNext()) {
            HandlerMapping hm = (HandlerMapping)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            if (cache) {
                request.setAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE, (Object)handler);
            }
            return handler;
        }
        return null;
    }

    protected void noHandlerFound(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (pageNotFoundLogger.isWarnEnabled()) {
            String requestUri = new UrlPathHelper().getRequestUri(request);
            pageNotFoundLogger.warn((Object)("No mapping found for HTTP request with URI [" + requestUri + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        response.sendError(404);
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        Iterator it = this.handlerAdapters.iterator();
        while (it.hasNext()) {
            HandlerAdapter ha = (HandlerAdapter)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new ServletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView exMv = null;
        Iterator it = this.handlerExceptionResolvers.iterator();
        while (exMv == null && it.hasNext()) {
            HandlerExceptionResolver resolver = (HandlerExceptionResolver)it.next();
            exMv = resolver.resolveException(request, response, handler, ex);
        }
        if (exMv != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Handler execution resulted in exception - forwarding to resolved error view: " + exMv), (Throwable)ex);
            }
            return exMv;
        }
        throw ex;
    }

    protected void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = this.localeResolver.resolveLocale(request);
        response.setLocale(locale);
        View view = null;
        if (mv.isReference()) {
            view = this.resolveViewName(mv.getViewName(), mv.getModelInternal(), locale, request);
            if (view == null) {
                throw new ServletException("Could not resolve view with name '" + mv.getViewName() + "' in servlet with name '" + this.getServletName() + "'");
            }
        } else {
            view = mv.getView();
            if (view == null) {
                throw new ServletException("ModelAndView [" + mv + "] neither contains a view name nor a " + "View object in servlet with name '" + this.getServletName() + "'");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view [" + view + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        view.render(mv.getModelInternal(), request, response);
    }

    protected String getDefaultViewName(HttpServletRequest request) throws Exception {
        return this.viewNameTranslator.getViewName(request);
    }

    protected View resolveViewName(String viewName, Map model, Locale locale, HttpServletRequest request) throws Exception {
        Iterator it = this.viewResolvers.iterator();
        while (it.hasNext()) {
            ViewResolver viewResolver = (ViewResolver)it.next();
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    private void triggerAfterCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        HandlerInterceptor[] interceptors;
        if (mappedHandler != null && (interceptors = mappedHandler.getInterceptors()) != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = interceptors[i];
                try {
                    interceptor.afterCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    private void restoreAttributesAfterInclude(HttpServletRequest request, Map attributesSnapshot) {
        this.logger.debug((Object)"Restoring snapshot of request attributes after include");
        HashSet<String> attrsToCheck = new HashSet<String>();
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            if (!this.cleanupAfterInclude && !attrName.startsWith("org.springframework.web.servlet")) continue;
            attrsToCheck.add(attrName);
        }
        Iterator it = attrsToCheck.iterator();
        while (it.hasNext()) {
            String attrName = (String)it.next();
            Object attrValue = attributesSnapshot.get(attrName);
            if (attrValue != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring original value of attribute [" + attrName + "] after include"));
                }
                request.setAttribute(attrName, attrValue);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing attribute [" + attrName + "] after include"));
            }
            request.removeAttribute(attrName);
        }
    }

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, DispatcherServlet.class);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'DispatcherServlet.properties': " + ex.getMessage());
        }
    }
}

