/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.AbstractUrlViewController;
import org.springframework.web.util.UrlPathHelper;

public class UrlFilenameViewController
extends AbstractUrlViewController {
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private String prefix = "";
    private String suffix = "";
    private final Map viewNameCache = Collections.synchronizedMap(new HashMap());

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    protected String getViewNameForRequest(HttpServletRequest request) {
        String urlPath = this.extractOperableUrl(request);
        String viewName = (String)this.viewNameCache.get(urlPath);
        if (viewName == null) {
            viewName = this.extractViewNameFromUrlPath(urlPath);
            viewName = this.postProcessViewName(viewName);
            this.viewNameCache.put(urlPath, viewName);
        }
        return viewName;
    }

    protected String extractOperableUrl(HttpServletRequest request) {
        String urlPath = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (!StringUtils.hasText((String)urlPath)) {
            urlPath = this.urlPathHelper.getPathWithinApplication(request);
        }
        return urlPath;
    }

    protected String extractViewNameFromUrlPath(String uri) {
        int start = uri.charAt(0) == '/' ? 1 : 0;
        int lastIndex = uri.lastIndexOf(".");
        int end = lastIndex < 0 ? uri.length() : lastIndex;
        return uri.substring(start, end);
    }

    protected String postProcessViewName(String viewName) {
        return this.getPrefix() + viewName + this.getSuffix();
    }
}

