/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.util.NestedServletException;

public class MultiActionController
extends AbstractController
implements LastModified {
    public static final String LAST_MODIFIED_METHOD_SUFFIX = "LastModified";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private Validator[] validators;
    private Object delegate;
    private Map handlerMethodMap = new HashMap();
    private Map lastModifiedMethodMap = new HashMap();
    private Map exceptionHandlerMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$servlet$ModelAndView;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;

    public MultiActionController() {
        this.delegate = this;
        this.registerHandlerMethods(this.delegate);
    }

    public MultiActionController(Object delegate) {
        this.setDelegate(delegate);
    }

    public final void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public final MethodNameResolver getMethodNameResolver() {
        return this.methodNameResolver;
    }

    public final void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    public final Validator[] getValidators() {
        return this.validators;
    }

    public final void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
        this.registerHandlerMethods(this.delegate);
        if (this.handlerMethodMap.isEmpty()) {
            throw new IllegalStateException("No handler methods in class [" + this.delegate.getClass() + "]");
        }
    }

    private void registerHandlerMethods(Object delegate) {
        Method method;
        int i;
        this.handlerMethodMap.clear();
        this.lastModifiedMethodMap.clear();
        this.exceptionHandlerMap.clear();
        Method[] methods = delegate.getClass().getMethods();
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!this.isHandlerMethod(method)) continue;
            this.registerHandlerMethod(method);
            this.registerLastModifiedMethodIfExists(delegate, method);
        }
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!this.isExceptionHandlerMethod(method)) continue;
            this.registerExceptionHandlerMethod(method);
        }
    }

    private boolean isHandlerMethod(Method method) {
        Class<?> returnType;
        if ((class$org$springframework$web$servlet$ModelAndView == null ? (class$org$springframework$web$servlet$ModelAndView = MultiActionController.class$("org.springframework.web.servlet.ModelAndView")) : class$org$springframework$web$servlet$ModelAndView).equals(returnType = method.getReturnType()) || (class$java$util$Map == null ? (class$java$util$Map = MultiActionController.class$("java.util.Map")) : class$java$util$Map).equals(returnType) || Void.TYPE.equals(returnType)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            return parameterTypes.length >= 2 && (class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = MultiActionController.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).equals(parameterTypes[0]) && (class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = MultiActionController.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse).equals(parameterTypes[1]) && (!"handleRequest".equals(method.getName()) || parameterTypes.length != 2);
        }
        return false;
    }

    private boolean isExceptionHandlerMethod(Method method) {
        return this.isHandlerMethod(method) && method.getParameterTypes().length == 3 && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = MultiActionController.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(method.getParameterTypes()[2]);
    }

    private void registerHandlerMethod(Method method) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found action method [" + method + "]"));
        }
        this.handlerMethodMap.put(method.getName(), method);
    }

    private void registerLastModifiedMethodIfExists(Object delegate, Method method) {
        try {
            Method lastModifiedMethod = delegate.getClass().getMethod(method.getName() + LAST_MODIFIED_METHOD_SUFFIX, class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = MultiActionController.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
            this.lastModifiedMethodMap.put(method.getName(), lastModifiedMethod);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found last modified method for action method [" + method + "]"));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void registerExceptionHandlerMethod(Method method) {
        this.exceptionHandlerMap.put(method.getParameterTypes()[2], method);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found exception handler method [" + method + "]"));
        }
    }

    public long getLastModified(HttpServletRequest request) {
        try {
            String handlerMethodName = this.methodNameResolver.getHandlerMethodName(request);
            Method lastModifiedMethod = (Method)this.lastModifiedMethodMap.get(handlerMethodName);
            if (lastModifiedMethod != null) {
                try {
                    Long wrappedLong = (Long)lastModifiedMethod.invoke(this.delegate, request);
                    return wrappedLong;
                }
                catch (Exception ex) {
                    this.logger.error((Object)"Failed to invoke last-modified method", (Throwable)ex);
                }
            }
        }
        catch (NoSuchRequestHandlingMethodException noSuchRequestHandlingMethodException) {
            // empty catch block
        }
        return -1L;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String methodName = this.methodNameResolver.getHandlerMethodName(request);
            return this.invokeNamedMethod(methodName, request, response);
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            return this.handleNoSuchRequestHandlingMethod(ex, request, response);
        }
    }

    protected ModelAndView handleNoSuchRequestHandlingMethod(NoSuchRequestHandlingMethodException ex, HttpServletRequest request, HttpServletResponse response) throws Exception {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        response.sendError(404);
        return null;
    }

    protected final ModelAndView invokeNamedMethod(String methodName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Method method = (Method)this.handlerMethodMap.get(methodName);
        if (method == null) {
            throw new NoSuchRequestHandlingMethodException(methodName, this.getClass());
        }
        try {
            ArrayList<Object> params = new ArrayList<Object>(4);
            params.add(request);
            params.add(response);
            if (method.getParameterTypes().length >= 3 && method.getParameterTypes()[2].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    throw new HttpSessionRequiredException("Pre-existing session required for handler method '" + methodName + "'");
                }
                params.add(session);
            }
            if (method.getParameterTypes().length >= 3 && !method.getParameterTypes()[method.getParameterTypes().length - 1].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                Object command = this.newCommandObject(method.getParameterTypes()[method.getParameterTypes().length - 1]);
                params.add(command);
                this.bind(request, command);
            }
            Object returnValue = method.invoke(this.delegate, params.toArray(new Object[params.size()]));
            return this.massageReturnValueIfNecessary(returnValue);
        }
        catch (InvocationTargetException ex) {
            return this.handleException(request, response, ex.getTargetException());
        }
        catch (Exception ex) {
            return this.handleException(request, response, ex);
        }
    }

    private ModelAndView massageReturnValueIfNecessary(Object returnValue) {
        if (returnValue instanceof ModelAndView) {
            return (ModelAndView)returnValue;
        }
        if (returnValue instanceof Map) {
            return new ModelAndView().addAllObjects((Map)returnValue);
        }
        return null;
    }

    protected Object newCommandObject(Class clazz) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Must create new command of class [" + clazz.getName() + "]"));
        }
        return BeanUtils.instantiateClass((Class)clazz);
    }

    protected void bind(HttpServletRequest request, Object command) throws Exception {
        this.logger.debug((Object)"Binding request parameters onto MultiActionController command");
        ServletRequestDataBinder binder = this.createBinder(request, command);
        binder.bind((ServletRequest)request);
        if (this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (!this.validators[i].supports(command.getClass())) continue;
                ValidationUtils.invokeValidator((Validator)this.validators[i], (Object)command, (Errors)binder.getBindingResult());
            }
        }
        binder.closeNoCatch();
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object command) throws Exception {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(command, this.getCommandName(command));
        this.initBinder(request, binder);
        return binder;
    }

    protected String getCommandName(Object command) {
        return DEFAULT_COMMAND_NAME;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        this.initBinder((ServletRequest)request, binder);
    }

    protected void initBinder(ServletRequest request, ServletRequestDataBinder binder) throws Exception {
    }

    protected Method getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to find handler for exception class [" + exceptionClass.getName() + "]"));
        }
        Method handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        while (handler == null && !exceptionClass.equals(class$java$lang$Throwable == null ? MultiActionController.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Trying to find handler for exception superclass [" + exceptionClass.getName() + "]"));
            }
            exceptionClass = exceptionClass.getSuperclass();
            handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        }
        return handler;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Throwable ex) throws Exception {
        Method handler = this.getExceptionHandler(ex);
        if (handler != null) {
            return this.invokeExceptionHandler(handler, request, response, ex);
        }
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new NestedServletException("Unknown Throwable type encountered", ex);
    }

    private ModelAndView invokeExceptionHandler(Method handler, HttpServletRequest request, HttpServletResponse response, Throwable ex) throws Exception {
        if (handler == null) {
            throw new NestedServletException("No handler for exception", ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking exception handler [" + handler + "] for exception [" + ex + "]"));
        }
        try {
            Object returnValue = handler.invoke(this.delegate, request, response, ex);
            return this.massageReturnValueIfNecessary(returnValue);
        }
        catch (InvocationTargetException ex2) {
            Throwable targetEx = ex2.getTargetException();
            if (targetEx instanceof Exception) {
                throw (Exception)targetEx;
            }
            if (targetEx instanceof Error) {
                throw (Error)targetEx;
            }
            throw new NestedServletException("Unknown Throwable type encountered", targetEx);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

