/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.reactive.accept.ApiVersionResolver;
import org.springframework.web.server.ServerWebExchange;

public class PathApiVersionResolver
implements ApiVersionResolver {
    private final int pathSegmentIndex;

    public PathApiVersionResolver(int pathSegmentIndex) {
        Assert.isTrue((pathSegmentIndex >= 0 ? 1 : 0) != 0, (String)"'pathSegmentIndex' must be >= 0");
        this.pathSegmentIndex = pathSegmentIndex;
    }

    @Override
    public String resolveVersion(ServerWebExchange exchange2) {
        int i2 = 0;
        for (PathContainer.Element e : exchange2.getRequest().getPath().pathWithinApplication().elements()) {
            if (!(e instanceof PathContainer.PathSegment) || i2++ != this.pathSegmentIndex) continue;
            return e.value();
        }
        throw new InvalidApiVersionException("No path segment at index " + this.pathSegmentIndex);
    }
}

