/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import org.webjars.WebJarVersionLocator;
import reactor.core.publisher.Mono;

public class LiteWebJarsResourceResolver
extends AbstractResourceResolver {
    private static final int WEBJARS_LOCATION_LENGTH = "META-INF/resources/webjars".length() + 1;
    private final WebJarVersionLocator webJarVersionLocator;

    public LiteWebJarsResourceResolver() {
        this.webJarVersionLocator = new WebJarVersionLocator();
    }

    public LiteWebJarsResourceResolver(WebJarVersionLocator webJarVersionLocator) {
        this.webJarVersionLocator = webJarVersionLocator;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveResource(exchange2, requestPath, locations).switchIfEmpty(Mono.defer(() -> {
            String webJarsResourcePath = this.findWebJarResourcePath(requestPath);
            if (webJarsResourcePath != null) {
                return chain.resolveResource(exchange2, webJarsResourcePath, locations);
            }
            return Mono.empty();
        }));
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations).switchIfEmpty(Mono.defer(() -> {
            String webJarResourcePath = this.findWebJarResourcePath(resourceUrlPath);
            if (webJarResourcePath != null) {
                return chain.resolveUrlPath(webJarResourcePath, locations);
            }
            return Mono.empty();
        }));
    }

    @Nullable
    protected String findWebJarResourcePath(String path) {
        String partialPath;
        int startOffset;
        String webjar;
        String webJarPath;
        int endOffset = path.indexOf(47, 1);
        if (endOffset != -1 && (webJarPath = this.webJarVersionLocator.fullPath(webjar = path.substring(startOffset = path.startsWith("/") ? 1 : 0, endOffset), partialPath = path.substring(endOffset + 1))) != null) {
            return webJarPath.substring(WEBJARS_LOCATION_LENGTH);
        }
        return null;
    }
}

