/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.HandlerResultHandlerSupport;
import org.springframework.web.reactive.result.view.Rendering;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ViewResolutionResultHandler
extends HandlerResultHandlerSupport
implements HandlerResultHandler,
Ordered {
    private static final Object NO_VALUE = new Object();
    private static final Mono<Object> NO_VALUE_MONO = Mono.just((Object)NO_VALUE);
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(4);
    private final List<View> defaultViews = new ArrayList<View>(4);

    public ViewResolutionResultHandler(List<ViewResolver> viewResolvers, RequestedContentTypeResolver contentTypeResolver) {
        this(viewResolvers, contentTypeResolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    public ViewResolutionResultHandler(List<ViewResolver> viewResolvers, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry registry) {
        super(contentTypeResolver, registry);
        this.viewResolvers.addAll(viewResolvers);
        AnnotationAwareOrderComparator.sort(this.viewResolvers);
    }

    public List<ViewResolver> getViewResolvers() {
        return Collections.unmodifiableList(this.viewResolvers);
    }

    public void setDefaultViews(@Nullable List<View> defaultViews) {
        this.defaultViews.clear();
        if (defaultViews != null) {
            this.defaultViews.addAll(defaultViews);
        }
    }

    public List<View> getDefaultViews() {
        return this.defaultViews;
    }

    @Override
    public boolean supports(HandlerResult result) {
        if (this.hasModelAnnotation(result.getReturnTypeSource())) {
            return true;
        }
        Class type = result.getReturnType().toClass();
        ReactiveAdapter adapter = this.getAdapter(result);
        if (adapter != null) {
            if (adapter.isNoValue()) {
                return true;
            }
            type = result.getReturnType().getGeneric(new int[0]).toClass();
        }
        return CharSequence.class.isAssignableFrom(type) || Rendering.class.isAssignableFrom(type) || Model.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || View.class.isAssignableFrom(type) || !BeanUtils.isSimpleProperty((Class)type);
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange2, HandlerResult result) {
        ResolvableType valueType;
        Mono valueMono;
        ReactiveAdapter adapter = this.getAdapter(result);
        if (adapter != null) {
            if (adapter.isMultiValue()) {
                throw new IllegalArgumentException("Multi-value reactive types not supported in view resolution: " + result.getReturnType());
            }
            valueMono = result.getReturnValue() != null ? Mono.from((Publisher)adapter.toPublisher(result.getReturnValue())) : Mono.empty();
            valueType = adapter.isNoValue() ? ResolvableType.forClass(Void.class) : result.getReturnType().getGeneric(new int[0]);
        } else {
            valueMono = Mono.justOrEmpty((Object)result.getReturnValue());
            valueType = result.getReturnType();
        }
        return valueMono.switchIfEmpty(exchange2.isNotModified() ? Mono.empty() : NO_VALUE_MONO).flatMap(returnValue -> {
            Mono<List<View>> viewsMono;
            Model model = result.getModel();
            MethodParameter parameter = result.getReturnTypeSource();
            Locale locale = LocaleContextHolder.getLocale((LocaleContext)exchange2.getLocaleContext());
            Class<?> clazz = valueType.toClass();
            if (clazz == Object.class) {
                clazz = returnValue.getClass();
            }
            if (returnValue == NO_VALUE || clazz == Void.TYPE || clazz == Void.class) {
                viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
            } else if (CharSequence.class.isAssignableFrom(clazz) && !this.hasModelAnnotation(parameter)) {
                viewsMono = this.resolveViews(returnValue.toString(), locale);
            } else if (Rendering.class.isAssignableFrom(clazz)) {
                Mono<List<View>> mono;
                Rendering render = (Rendering)returnValue;
                HttpStatusCode status = render.status();
                if (status != null) {
                    exchange2.getResponse().setStatusCode(status);
                }
                exchange2.getResponse().getHeaders().putAll((Map)render.headers());
                model.addAllAttributes(render.modelAttributes());
                Object view = render.view();
                if (view == null) {
                    view = this.getDefaultViewName(exchange2);
                }
                if (view instanceof String) {
                    String viewName = (String)view;
                    mono = this.resolveViews(viewName, locale);
                } else {
                    mono = Mono.just(Collections.singletonList((View)view));
                }
                viewsMono = mono;
            } else if (Model.class.isAssignableFrom(clazz)) {
                model.addAllAttributes(((Model)returnValue).asMap());
                viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
            } else if (Map.class.isAssignableFrom(clazz) && !this.hasModelAnnotation(parameter)) {
                model.addAllAttributes((Map)returnValue);
                viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
            } else if (View.class.isAssignableFrom(clazz)) {
                viewsMono = Mono.just(Collections.singletonList((View)returnValue));
            } else {
                String name = this.getNameForReturnValue(parameter);
                model.addAttribute(name, returnValue);
                viewsMono = this.resolveViews(this.getDefaultViewName(exchange2), locale);
            }
            BindingContext bindingContext = result.getBindingContext();
            bindingContext.updateModel(exchange2);
            return viewsMono.flatMap(views -> this.render((List<View>)views, model.asMap(), bindingContext, exchange2));
        });
    }

    private boolean hasModelAnnotation(MethodParameter parameter) {
        return parameter.hasMethodAnnotation(ModelAttribute.class);
    }

    private String getDefaultViewName(ServerWebExchange exchange2) {
        String path = exchange2.getRequest().getPath().pathWithinApplication().value();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return StringUtils.stripFilenameExtension((String)path);
    }

    private Mono<List<View>> resolveViews(String viewName, Locale locale) {
        return Flux.fromIterable(this.getViewResolvers()).concatMap(resolver -> resolver.resolveViewName(viewName, locale)).collectList().map(views -> {
            if (views.isEmpty()) {
                throw new IllegalStateException("Could not resolve view with name '" + viewName + "'.");
            }
            views.addAll(this.getDefaultViews());
            return views;
        });
    }

    private String getNameForReturnValue(MethodParameter returnType) {
        return Optional.ofNullable((ModelAttribute)returnType.getMethodAnnotation(ModelAttribute.class)).filter(ann -> StringUtils.hasText((String)ann.value())).map(ModelAttribute::value).orElseGet(() -> Conventions.getVariableNameForParameter((MethodParameter)returnType));
    }

    private Mono<? extends Void> render(List<View> views, Map<String, Object> model, BindingContext bindingContext, ServerWebExchange exchange2) {
        MediaType bestMediaType;
        for (View view : views) {
            if (!view.isRedirectView()) continue;
            return this.renderWith(view, model, null, exchange2, bindingContext);
        }
        List<MediaType> mediaTypes = this.getMediaTypes(views);
        try {
            bestMediaType = this.selectMediaType(exchange2, () -> mediaTypes);
        }
        catch (NotAcceptableStatusException ex) {
            HttpStatusCode statusCode = exchange2.getResponse().getStatusCode();
            if (statusCode != null && statusCode.isError()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring error response content (if any). " + ex.getReason()));
                }
                return Mono.empty();
            }
            throw ex;
        }
        if (bestMediaType != null) {
            for (View view : views) {
                for (MediaType mediaType : view.getSupportedMediaTypes()) {
                    if (!mediaType.isCompatibleWith(bestMediaType)) continue;
                    return this.renderWith(view, model, mediaType, exchange2, bindingContext);
                }
            }
        }
        throw new NotAcceptableStatusException(mediaTypes);
    }

    private Mono<? extends Void> renderWith(View view, Map<String, Object> model, @Nullable MediaType mediaType, ServerWebExchange exchange2, BindingContext bindingContext) {
        exchange2.getAttributes().put(View.BINDING_CONTEXT_ATTRIBUTE, bindingContext);
        return view.render(model, mediaType, exchange2).doOnTerminate(() -> exchange2.getAttributes().remove(View.BINDING_CONTEXT_ATTRIBUTE));
    }

    private List<MediaType> getMediaTypes(List<View> views) {
        return views.stream().flatMap(view -> view.getSupportedMediaTypes().stream()).toList();
    }
}

