/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientHttpObservationDocumentation;
import org.springframework.web.reactive.function.client.ClientRequestObservationContext;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.ClientResponse;

public class DefaultClientRequestObservationConvention
implements ClientRequestObservationConvention {
    private static final String DEFAULT_NAME = "http.client.requests";
    private static final KeyValue URI_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"none");
    private static final KeyValue METHOD_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)"none");
    private static final KeyValue STATUS_IO_ERROR = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)"IO_ERROR");
    private static final KeyValue STATUS_CLIENT_ERROR = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)"CLIENT_ERROR");
    private static final KeyValue HTTP_OUTCOME_SUCCESS = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"SUCCESS");
    private static final KeyValue HTTP_OUTCOME_UNKNOWN = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"UNKNOWN");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue HTTP_URL_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)"none");
    private static final KeyValue CLIENT_NAME_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.CLIENT_NAME, (String)"none");
    private final String name;

    public DefaultClientRequestObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultClientRequestObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getContextualName(ClientRequestObservationContext context) {
        return "http " + context.getRequest().method().name().toLowerCase();
    }

    public KeyValues getLowCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.uri(context), this.method(context), this.status(context), this.exception(context), this.outcome(context)});
    }

    protected KeyValue uri(ClientRequestObservationContext context) {
        if (context.getUriTemplate() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)context.getUriTemplate());
        }
        return URI_NONE;
    }

    protected KeyValue method(ClientRequestObservationContext context) {
        if (context.getRequest() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)context.getRequest().method().name());
        }
        return METHOD_NONE;
    }

    protected KeyValue status(ClientRequestObservationContext context) {
        if (context.isAborted()) {
            return STATUS_CLIENT_ERROR;
        }
        ClientResponse response = (ClientResponse)context.getResponse();
        if (response != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)String.valueOf(response.statusCode().value()));
        }
        if (context.getError() != null && context.getError() instanceof IOException) {
            return STATUS_IO_ERROR;
        }
        return STATUS_CLIENT_ERROR;
    }

    protected KeyValue exception(ClientRequestObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(StringUtils.hasText((String)simpleName) ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue outcome(ClientRequestObservationContext context) {
        if (context.isAborted()) {
            return HTTP_OUTCOME_UNKNOWN;
        }
        if (context.getResponse() != null) {
            return HttpOutcome.forStatus(((ClientResponse)context.getResponse()).statusCode());
        }
        return HTTP_OUTCOME_UNKNOWN;
    }

    public KeyValues getHighCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.httpUrl(context), this.clientName(context)});
    }

    protected KeyValue httpUrl(ClientRequestObservationContext context) {
        if (context.getRequest() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)context.getRequest().url().toASCIIString());
        }
        return HTTP_URL_NONE;
    }

    protected KeyValue clientName(ClientRequestObservationContext context) {
        if (context.getRequest() != null && context.getRequest().url().getHost() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.CLIENT_NAME, (String)context.getRequest().url().getHost());
        }
        return CLIENT_NAME_NONE;
    }

    static class HttpOutcome {
        HttpOutcome() {
        }

        static KeyValue forStatus(HttpStatusCode statusCode) {
            if (statusCode.is2xxSuccessful()) {
                return HTTP_OUTCOME_SUCCESS;
            }
            if (statusCode instanceof HttpStatus) {
                HttpStatus status = (HttpStatus)statusCode;
                return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)status.series().name());
            }
            return HTTP_OUTCOME_UNKNOWN;
        }
    }
}

